/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.LocalMemberResetException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.NonCompletableFuture;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.serialization.SerializationService;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public abstract class AbstractJobProxy<T>
implements Job {
    private final long jobId;
    private final ILogger logger;
    private final T container;
    private final NonCompletableFuture future = new NonCompletableFuture();
    private final AtomicBoolean joinedJob = new AtomicBoolean();
    private final AtomicBoolean cancelledJob = new AtomicBoolean();
    private final ExecutionCallback<Void> joinJobCallback = new JoinJobCallback();
    private final Supplier<JobConfig> jobConfigSup;
    private final Supplier<Long> submissionTimeSup = Util.memoizeConcurrent(this::doGetJobSubmissionTime);

    AbstractJobProxy(T container, long jobId) {
        this.jobId = jobId;
        this.jobConfigSup = Util.memoizeConcurrent(this::doGetJobConfig);
        this.container = container;
        this.logger = this.createLogger();
    }

    AbstractJobProxy(T container, long jobId, DAG dag, JobConfig config) {
        this.jobId = jobId;
        this.jobConfigSup = () -> config;
        this.container = container;
        this.logger = this.createLogger();
        this.doSubmitJob(dag, config);
        this.joinedJob.set(true);
        this.doInvokeJoinJob();
    }

    @Override
    public long getId() {
        return this.jobId;
    }

    @Override
    @Nonnull
    public JobConfig getConfig() {
        return this.jobConfigSup.get();
    }

    @Override
    @Nonnull
    public CompletableFuture<Void> getFuture() {
        if (this.joinedJob.compareAndSet(false, true)) {
            this.doInvokeJoinJob();
        }
        return this.future;
    }

    @Override
    public long getSubmissionTime() {
        return this.submissionTimeSup.get();
    }

    @Override
    public boolean cancel() {
        boolean cancelled = this.cancelledJob.compareAndSet(false, true);
        if (cancelled) {
            this.logger.fine("Sending Cancel Job " + Util.idToString(this.jobId) + " request.");
            this.invokeCancelJob().andThen(new CancelJobCallback());
        }
        return cancelled;
    }

    public String toString() {
        return "Job{id=" + Util.idToString(this.jobId) + ", name=" + this.getName() + ", submissionTime=" + Util.toLocalDateTime(this.getSubmissionTime()) + ", status=" + (Object)((Object)this.getStatus()) + "}";
    }

    protected abstract ICompletableFuture<Void> invokeSubmitJob(Data var1, JobConfig var2);

    protected abstract ICompletableFuture<Void> invokeJoinJob();

    protected abstract ICompletableFuture<Void> invokeCancelJob();

    protected abstract long doGetJobSubmissionTime();

    protected abstract JobConfig doGetJobConfig();

    protected abstract Address masterAddress();

    protected abstract SerializationService serializationService();

    protected abstract LoggingService loggingService();

    protected ILogger getLogger() {
        return this.logger;
    }

    protected T container() {
        return this.container;
    }

    private void doSubmitJob(DAG dag, JobConfig config) {
        CompletableFuture<Void> submitFuture = new CompletableFuture<Void>();
        SubmitJobCallback callback = new SubmitJobCallback(submitFuture, dag, config);
        this.invokeSubmitJob((Data)this.serializationService().toData(dag), config).andThen(callback);
        submitFuture.join();
    }

    private boolean isRestartable(Throwable t) {
        return t instanceof MemberLeftException || t instanceof TargetDisconnectedException || t instanceof TargetNotMemberException;
    }

    private void doInvokeJoinJob() {
        this.invokeJoinJob().andThen(this.joinJobCallback);
    }

    private ILogger createLogger() {
        return this.loggingService().getLogger(Job.class + "." + Util.idToString(this.jobId));
    }

    private class CancelJobCallback
    implements ExecutionCallback<Void> {
        private CancelJobCallback() {
        }

        @Override
        public void onResponse(Void response) {
            AbstractJobProxy.this.logger.fine("Job " + Util.idToString(AbstractJobProxy.this.jobId) + " is cancelled.");
        }

        @Override
        public void onFailure(Throwable t) {
            Throwable ex = ExceptionUtil.peel(t);
            if (AbstractJobProxy.this.isRestartable(ex)) {
                AbstractJobProxy.this.logger.fine("Re-sending cancel request for Job " + Util.idToString(AbstractJobProxy.this.jobId));
                AbstractJobProxy.this.invokeCancelJob().andThen(this);
            } else {
                AbstractJobProxy.this.logger.severe("Cancellation of Job " + Util.idToString(AbstractJobProxy.this.jobId) + " failed.", t);
            }
        }
    }

    private class JoinJobCallback
    implements ExecutionCallback<Void> {
        private JoinJobCallback() {
        }

        @Override
        public void onResponse(Void response) {
            AbstractJobProxy.this.future.internalComplete();
        }

        @Override
        public synchronized void onFailure(Throwable t) {
            Throwable ex = ExceptionUtil.peel(t);
            if (ex instanceof LocalMemberResetException) {
                String msg = "Job " + Util.idToString(AbstractJobProxy.this.jobId) + " failed because the cluster is performing split-brain merge";
                AbstractJobProxy.this.logger.warning(msg, ex);
                AbstractJobProxy.this.future.internalCompleteExceptionally(new CancellationException(msg));
            } else if (!AbstractJobProxy.this.isRestartable(ex)) {
                AbstractJobProxy.this.future.internalCompleteExceptionally(ex);
            } else {
                try {
                    this.rejoinJob(t);
                }
                catch (Exception e) {
                    AbstractJobProxy.this.future.internalCompleteExceptionally(ExceptionUtil.peel(e));
                }
            }
        }

        private void rejoinJob(Throwable t) {
            if (AbstractJobProxy.this.masterAddress() != null) {
                AbstractJobProxy.this.logger.fine("Rejoining to job " + Util.idToString(AbstractJobProxy.this.jobId) + " after " + t.getClass().getSimpleName());
                AbstractJobProxy.this.doInvokeJoinJob();
                return;
            }
            String msg = "Job " + Util.idToString(AbstractJobProxy.this.jobId) + " failed because the cluster is performing  split-brain merge and coordinator is not known";
            AbstractJobProxy.this.logger.warning(msg, t);
            AbstractJobProxy.this.future.internalCompleteExceptionally(new CancellationException(msg));
        }
    }

    private class SubmitJobCallback
    implements ExecutionCallback<Void> {
        private final CompletableFuture<Void> future;
        private final DAG dag;
        private final JobConfig config;

        SubmitJobCallback(CompletableFuture<Void> future, DAG dag, JobConfig config) {
            this.future = future;
            this.dag = dag;
            this.config = config;
        }

        @Override
        public void onResponse(Void response) {
            this.future.complete(null);
        }

        @Override
        public synchronized void onFailure(Throwable t) {
            Throwable ex = ExceptionUtil.peel(t);
            if (ex instanceof LocalMemberResetException) {
                String msg = "Job " + Util.idToString(AbstractJobProxy.this.jobId) + " failed because the cluster is performing split-brain merge";
                AbstractJobProxy.this.logger.warning(msg, ex);
                this.future.completeExceptionally(new CancellationException(msg));
            } else if (!AbstractJobProxy.this.isRestartable(ex)) {
                String msg = "Job " + Util.idToString(AbstractJobProxy.this.jobId) + " failed because it has received a non-restartable exception during submission";
                AbstractJobProxy.this.logger.warning(msg, ex);
                this.future.completeExceptionally(ex);
            } else {
                try {
                    this.resubmitJob(t);
                }
                catch (Exception e) {
                    this.future.completeExceptionally(ExceptionUtil.peel(e));
                }
            }
        }

        private void resubmitJob(Throwable t) {
            if (AbstractJobProxy.this.masterAddress() != null) {
                AbstractJobProxy.this.logger.fine("Resubmitting job " + Util.idToString(AbstractJobProxy.this.jobId) + " after " + t.getClass().getSimpleName());
                AbstractJobProxy.this.invokeSubmitJob((Data)AbstractJobProxy.this.serializationService().toData(this.dag), this.config).andThen(this);
                return;
            }
            String msg = "Job " + Util.idToString(AbstractJobProxy.this.jobId) + " failed because the cluster is performing  split-brain merge and coordinator is not known";
            AbstractJobProxy.this.logger.warning(msg, t);
            this.future.completeExceptionally(new CancellationException(msg));
        }
    }
}

