/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.function;

import com.hazelcast.util.Preconditions;
import java.io.Serializable;
import java.util.Comparator;
import java.util.function.BinaryOperator;

@FunctionalInterface
public interface DistributedBinaryOperator<T>
extends BinaryOperator<T>,
Serializable {
    public static <T> DistributedBinaryOperator<T> minBy(Comparator<? super T> comparator) {
        Preconditions.checkNotNull(comparator, "comparator");
        return (l, r) -> comparator.compare(l, r) <= 0 ? l : r;
    }

    public static <T> DistributedBinaryOperator<T> maxBy(Comparator<? super T> comparator) {
        Preconditions.checkNotNull(comparator, "comparator");
        return (l, r) -> comparator.compare(l, r) >= 0 ? l : r;
    }
}

