/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.datamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class ThreeBags<T0, T1, T2> {
    private final Collection<T0> bag0;
    private final Collection<T1> bag1;
    private final Collection<T2> bag2;

    private ThreeBags(@Nonnull Collection<T0> bag0, @Nonnull Collection<T1> bag1, @Nonnull Collection<T2> bag2) {
        this.bag0 = new ArrayList<T0>(bag0);
        this.bag1 = new ArrayList<T1>(bag1);
        this.bag2 = new ArrayList<T2>(bag2);
    }

    @Nonnull
    public static <E0, E1, E2> ThreeBags<E0, E1, E2> threeBags() {
        return new ThreeBags(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    @Nonnull
    public static <E0, E1, E2> ThreeBags<E0, E1, E2> threeBags(@Nonnull Collection<E0> bag0, @Nonnull Collection<E1> bag1, @Nonnull Collection<E2> bag2) {
        return new ThreeBags<E0, E1, E2>(bag0, bag1, bag2);
    }

    @Nonnull
    public Collection<T0> bag0() {
        return this.bag0;
    }

    @Nonnull
    public Collection<T1> bag1() {
        return this.bag1;
    }

    @Nonnull
    public Collection<T2> bag2() {
        return this.bag2;
    }

    public void combineWith(@Nonnull ThreeBags<T0, T1, T2> that) {
        this.bag0.addAll(that.bag0());
        this.bag1.addAll(that.bag1());
        this.bag2.addAll(that.bag2());
    }

    public void deduct(@Nonnull ThreeBags<T0, T1, T2> that) {
        this.bag0.removeAll(that.bag0());
        this.bag1.removeAll(that.bag1());
        this.bag2.removeAll(that.bag2());
    }

    public ThreeBags<T0, T1, T2> finish() {
        return new ThreeBags<T0, T1, T2>(new ArrayList<T0>(this.bag0), new ArrayList<T1>(this.bag1), new ArrayList<T2>(this.bag2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ThreeBags)) return false;
        ThreeBags that = (ThreeBags)o;
        if (!Objects.equals(this.bag0, that.bag0)) return false;
        if (!Objects.equals(this.bag1, that.bag1)) return false;
        if (!Objects.equals(this.bag2, that.bag2)) return false;
        return true;
    }

    public int hashCode() {
        int hc = Objects.hashCode(this.bag0);
        hc = 73 * hc + Objects.hashCode(this.bag1);
        hc = 73 * hc + Objects.hashCode(this.bag2);
        return hc;
    }

    public String toString() {
        return "ThreeBags{bag0=" + this.bag0 + ", bag1=" + this.bag1 + ", bag2=" + this.bag2 + '}';
    }
}

