/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import com.hazelcast.jet.config.JobClassLoaderFactory;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.config.ResourceConfig;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.util.Preconditions;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JobConfig
implements Serializable {
    private static final int SNAPSHOT_INTERVAL_MILLIS_DEFAULT = 10000;
    private String name;
    private ProcessingGuarantee processingGuarantee = ProcessingGuarantee.NONE;
    private long snapshotIntervalMillis = 10000L;
    private boolean splitBrainProtectionEnabled;
    private final List<ResourceConfig> resourceConfigs = new ArrayList<ResourceConfig>();
    private boolean autoRestartEnabled = true;
    private int maxWatermarkRetainMillis = -1;
    private JobClassLoaderFactory classLoaderFactory;

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nonnull
    public JobConfig setName(@Nullable String name) {
        this.name = name;
        return this;
    }

    public boolean isSplitBrainProtectionEnabled() {
        return this.splitBrainProtectionEnabled;
    }

    @Nonnull
    public JobConfig setSplitBrainProtection(boolean isEnabled) {
        this.splitBrainProtectionEnabled = isEnabled;
        return this;
    }

    public boolean isAutoRestartOnMemberFailureEnabled() {
        return this.autoRestartEnabled;
    }

    @Nonnull
    public JobConfig setAutoRestartOnMemberFailure(boolean isEnabled) {
        this.autoRestartEnabled = isEnabled;
        return this;
    }

    @Nonnull
    public ProcessingGuarantee getProcessingGuarantee() {
        return this.processingGuarantee;
    }

    @Nonnull
    public JobConfig setProcessingGuarantee(@Nonnull ProcessingGuarantee processingGuarantee) {
        this.processingGuarantee = processingGuarantee;
        return this;
    }

    public long getSnapshotIntervalMillis() {
        return this.snapshotIntervalMillis;
    }

    @Nonnull
    public JobConfig setSnapshotIntervalMillis(long snapshotInterval) {
        Preconditions.checkNotNegative(snapshotInterval, "snapshotInterval can't be negative");
        this.snapshotIntervalMillis = snapshotInterval;
        return this;
    }

    @Nonnull
    public JobConfig setMaxWatermarkRetainMillis(int retainMillis) {
        this.maxWatermarkRetainMillis = retainMillis;
        return this;
    }

    public int getMaxWatermarkRetainMillis() {
        return this.maxWatermarkRetainMillis;
    }

    @Nonnull
    public JobConfig addClass(Class ... classes) {
        Preconditions.checkNotNull(classes, "Classes can not be null");
        for (Class clazz : classes) {
            this.resourceConfigs.add(new ResourceConfig(clazz));
        }
        return this;
    }

    @Nonnull
    public JobConfig addJar(@Nonnull URL url) {
        return this.add(url, null, true);
    }

    @Nonnull
    public JobConfig addJar(@Nonnull File file) {
        try {
            return this.addJar(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Nonnull
    public JobConfig addJar(@Nonnull String path) {
        try {
            File file = new File(path);
            return this.addJar(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Nonnull
    public JobConfig addResource(@Nonnull URL url) {
        return this.addResource(url, JobConfig.toFilename(url));
    }

    @Nonnull
    public JobConfig addResource(@Nonnull URL url, @Nonnull String id) {
        return this.add(url, id, false);
    }

    @Nonnull
    public JobConfig addResource(@Nonnull File file) {
        try {
            return this.addResource(file.toURI().toURL(), file.getName());
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Nonnull
    public JobConfig addResource(@Nonnull File file, @Nonnull String id) {
        try {
            return this.add(file.toURI().toURL(), id, false);
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Nonnull
    public JobConfig addResource(@Nonnull String path) {
        return this.addResource(new File(path));
    }

    @Nonnull
    public JobConfig addResource(@Nonnull String path, @Nonnull String id) {
        return this.addResource(new File(path), id);
    }

    @Nonnull
    public List<ResourceConfig> getResourceConfigs() {
        return this.resourceConfigs;
    }

    private JobConfig add(URL url, String id, boolean isJar) {
        this.resourceConfigs.add(new ResourceConfig(url, id, isJar));
        return this;
    }

    private static String toFilename(URL url) {
        String urlFile = url.getPath();
        return urlFile.substring(urlFile.lastIndexOf(47) + 1, urlFile.length());
    }

    public JobConfig setClassLoaderFactory(@Nullable JobClassLoaderFactory classLoaderFactory) {
        this.classLoaderFactory = classLoaderFactory;
        return this;
    }

    @Nullable
    public JobClassLoaderFactory getClassLoaderFactory() {
        return this.classLoaderFactory;
    }
}

