/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.instance.DefaultNodeExtension;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.NodeExtension;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.annotation.PrivateApi;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ServiceLoader;
import java.lang.reflect.Constructor;
import java.util.Iterator;

@PrivateApi
public final class NodeExtensionFactory {
    private static final String FACTORY_ID = "com.hazelcast.instance.NodeExtension";

    private NodeExtensionFactory() {
    }

    public static NodeExtension create(Node node) {
        try {
            ClassLoader classLoader = node.getConfigClassLoader();
            Iterator<Class<NodeExtension>> iter = ServiceLoader.classIterator(NodeExtension.class, FACTORY_ID, classLoader);
            while (iter.hasNext()) {
                Class<NodeExtension> clazz = iter.next();
                if (clazz.equals(DefaultNodeExtension.class)) continue;
                if (clazz.getName().equals(DefaultNodeExtension.class.getName())) {
                    Logger.getLogger(NodeExtensionFactory.class).warning("DefaultNodeExtension class has been loaded by two different class-loaders. Classloader 1: " + NodeExtensionFactory.class.getClassLoader() + ", Classloader 2: " + clazz.getClassLoader() + ". Are you running Hazelcast in an OSGi environment? If so, set the bundle class-loader in the Config using the setClassloader() method");
                }
                Constructor<NodeExtension> constructor = clazz.getDeclaredConstructor(Node.class);
                return constructor.newInstance(node);
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        return new DefaultNodeExtension(node);
    }
}

