/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.NlsString;

public class SqlOption
extends SqlCall {
    public static final SqlOperator OPERATOR = new SqlSpecialOperator("OPTION DECLARATION", SqlKind.OTHER);
    private final SqlNode key;
    private final SqlNode value;

    public SqlOption(SqlNode key, SqlNode value, SqlParserPos pos) {
        super(pos);
        this.key = Objects.requireNonNull(key, "Option key is missing");
        this.value = Objects.requireNonNull(value, "Option value is missing");
    }

    public SqlNode key() {
        return this.key;
    }

    public SqlNode value() {
        return this.value;
    }

    public String keyString() {
        return ((NlsString)SqlLiteral.value((SqlNode)this.key)).getValue();
    }

    public String valueString() {
        return ((NlsString)SqlLiteral.value((SqlNode)this.value)).getValue();
    }

    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.key, (Object)this.value);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.key.unparse(writer, leftPrec, rightPrec);
        this.value.unparse(writer, leftPrec, rightPrec);
    }
}

