/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.cluster.Address;
import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.BiPredicateEx;
import com.hazelcast.function.ConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.Functions;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.core.processor.SourceProcessors;
import com.hazelcast.jet.impl.execution.init.Contexts;
import com.hazelcast.jet.pipeline.ServiceFactories;
import com.hazelcast.jet.pipeline.ServiceFactory;
import com.hazelcast.jet.pipeline.SourceBuilder;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.SimpleExpressionEvalContext;
import com.hazelcast.jet.sql.impl.aggregate.ObjectArrayKey;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.SqlConnectorUtil;
import com.hazelcast.jet.sql.impl.opt.physical.AggregateAccumulateByKeyPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.AggregateAccumulatePhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.AggregateByKeyPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.AggregateCombineByKeyPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.AggregateCombinePhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.AggregatePhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.FilterPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.FullScanPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.InsertPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.JetRootRel;
import com.hazelcast.jet.sql.impl.opt.physical.JoinNestedLoopPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.PhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.ProjectPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.ValuesPhysicalRel;
import com.hazelcast.jet.sql.impl.processors.RootResultConsumerSink;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.schema.Table;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.calcite.rel.RelNode;

public class CreateDagVisitor {
    private final DAG dag = new DAG();
    private final Address localMemberAddress;

    public CreateDagVisitor(Address localMemberAddress) {
        this.localMemberAddress = localMemberAddress;
    }

    public Vertex onValues(ValuesPhysicalRel rel) {
        List<Object[]> values = rel.tuples();
        return this.dag.newUniqueVertex("Values", SourceProcessors.convenientSourceP((FunctionEx & Serializable)pCtx -> null, (BiConsumerEx & Serializable)(ignored, buffer) -> {
            values.forEach(arg_0 -> ((SourceBuilder.SourceBuffer)buffer).add(arg_0));
            buffer.close();
        }, (FunctionEx & Serializable)ctx -> null, (BiConsumerEx & Serializable)(ctx, states) -> {}, (ConsumerEx)ConsumerEx.noop(), (int)0, (boolean)true));
    }

    public Vertex onInsert(InsertPhysicalRel rel) {
        Table table = ((HazelcastTable)rel.getTable().unwrap(HazelcastTable.class)).getTarget();
        Vertex vertex = SqlConnectorUtil.getJetSqlConnector(table).sink(this.dag, table);
        this.connectInput(rel.getInput(), vertex, null);
        return vertex;
    }

    public Vertex onFullScan(FullScanPhysicalRel rel) {
        Table table = ((HazelcastTable)rel.getTable().unwrap(HazelcastTable.class)).getTarget();
        return SqlConnectorUtil.getJetSqlConnector(table).fullScanReader(this.dag, table, rel.filter(), rel.projection());
    }

    public Vertex onFilter(FilterPhysicalRel rel) {
        Expression<Boolean> filter = rel.filter();
        Vertex vertex = this.dag.newUniqueVertex("Filter", Processors.filterUsingServiceP((ServiceFactory)ServiceFactories.nonSharedService((FunctionEx & Serializable)ctx -> {
            InternalSerializationService serializationService = ((Contexts.ProcSupplierCtx)ctx).serializationService();
            SimpleExpressionEvalContext context = new SimpleExpressionEvalContext(serializationService);
            return ExpressionUtil.filterFn(filter, context);
        }), (BiPredicateEx & Serializable)(filterFn, row) -> filterFn.test(row)));
        this.connectInput(rel.getInput(), vertex, null);
        return vertex;
    }

    public Vertex onProject(ProjectPhysicalRel rel) {
        List<Expression<?>> projection = rel.projection();
        Vertex vertex = this.dag.newUniqueVertex("Project", Processors.mapUsingServiceP((ServiceFactory)ServiceFactories.nonSharedService((FunctionEx & Serializable)ctx -> {
            InternalSerializationService serializationService = ((Contexts.ProcSupplierCtx)ctx).serializationService();
            SimpleExpressionEvalContext context = new SimpleExpressionEvalContext(serializationService);
            return ExpressionUtil.projectionFn(projection, context);
        }), (BiFunctionEx & Serializable)(projectionFn, row) -> (Object[])projectionFn.apply(row)));
        this.connectInput(rel.getInput(), vertex, null);
        return vertex;
    }

    public Vertex onAggregate(AggregatePhysicalRel rel) {
        AggregateOperation<?, Object[]> aggregateOperation = rel.aggrOp();
        Vertex vertex = this.dag.newUniqueVertex("Aggregate", ProcessorMetaSupplier.forceTotalParallelismOne((ProcessorSupplier)ProcessorSupplier.of((SupplierEx)Processors.aggregateP(aggregateOperation)), (Address)this.localMemberAddress));
        this.connectInput(rel.getInput(), vertex, edge -> edge.distributeTo(this.localMemberAddress).allToOne((Object)""));
        return vertex;
    }

    public Vertex onAccumulate(AggregateAccumulatePhysicalRel rel) {
        AggregateOperation<?, Object[]> aggregateOperation = rel.aggrOp();
        Vertex vertex = this.dag.newUniqueVertex("Accumulate", Processors.accumulateP(aggregateOperation));
        this.connectInput(rel.getInput(), vertex, null);
        return vertex;
    }

    public Vertex onCombine(AggregateCombinePhysicalRel rel) {
        AggregateOperation<?, Object[]> aggregateOperation = rel.aggrOp();
        Vertex vertex = this.dag.newUniqueVertex("Combine", ProcessorMetaSupplier.forceTotalParallelismOne((ProcessorSupplier)ProcessorSupplier.of((SupplierEx)Processors.combineP(aggregateOperation)), (Address)this.localMemberAddress));
        this.connectInput(rel.getInput(), vertex, edge -> edge.distributeTo(this.localMemberAddress).allToOne((Object)""));
        return vertex;
    }

    public Vertex onAggregateByKey(AggregateByKeyPhysicalRel rel) {
        FunctionEx<Object[], ObjectArrayKey> groupKeyFn = rel.groupKeyFn();
        AggregateOperation<?, Object[]> aggregateOperation = rel.aggrOp();
        Vertex vertex = this.dag.newUniqueVertex("AggregateByKey", Processors.aggregateByKeyP(Collections.singletonList(groupKeyFn), aggregateOperation, (BiFunctionEx & Serializable)(key, value) -> value));
        this.connectInput(rel.getInput(), vertex, edge -> edge.distributed().partitioned(groupKeyFn));
        return vertex;
    }

    public Vertex onAccumulateByKey(AggregateAccumulateByKeyPhysicalRel rel) {
        FunctionEx<Object[], ObjectArrayKey> groupKeyFn = rel.groupKeyFn();
        AggregateOperation<?, Object[]> aggregateOperation = rel.aggrOp();
        Vertex vertex = this.dag.newUniqueVertex("AccumulateByKey", Processors.accumulateByKeyP(Collections.singletonList(groupKeyFn), aggregateOperation));
        this.connectInput(rel.getInput(), vertex, edge -> edge.partitioned(groupKeyFn));
        return vertex;
    }

    public Vertex onCombineByKey(AggregateCombineByKeyPhysicalRel rel) {
        AggregateOperation<?, Object[]> aggregateOperation = rel.aggrOp();
        Vertex vertex = this.dag.newUniqueVertex("CombineByKey", Processors.combineByKeyP(aggregateOperation, (BiFunctionEx & Serializable)(key, value) -> value));
        this.connectInput(rel.getInput(), vertex, edge -> edge.distributed().partitioned(Functions.entryKey()));
        return vertex;
    }

    public Vertex onNestedLoopJoin(JoinNestedLoopPhysicalRel rel) {
        assert (rel.getRight() instanceof FullScanPhysicalRel) : rel.getRight().getClass();
        Table rightTable = ((HazelcastTable)rel.getRight().getTable().unwrap(HazelcastTable.class)).getTarget();
        SqlConnector.VertexWithInputConfig vertexWithConfig = SqlConnectorUtil.getJetSqlConnector(rightTable).nestedLoopReader(this.dag, rightTable, rel.rightFilter(), rel.rightProjection(), rel.joinInfo());
        this.connectInput(rel.getLeft(), vertexWithConfig.vertex(), vertexWithConfig.configureEdgeFn());
        return vertexWithConfig.vertex();
    }

    public Vertex onRoot(JetRootRel rootRel) {
        Vertex vertex = this.dag.newUniqueVertex("ClientSink", RootResultConsumerSink.rootResultConsumerSink(rootRel.getInitiatorAddress()));
        this.connectInput(rootRel.getInput(), vertex, edge -> edge.distributeTo(this.localMemberAddress).allToOne((Object)""));
        return vertex;
    }

    public DAG getDag() {
        return this.dag;
    }

    private void connectInput(RelNode inputRel, Vertex thisVertex, @Nullable Consumer<Edge> configureEdgeFn) {
        Vertex inputVertex = ((PhysicalRel)inputRel).accept(this);
        Edge edge = Edge.between((Vertex)inputVertex, (Vertex)thisVertex);
        if (configureEdgeFn != null) {
            configureEdgeFn.accept(edge);
        }
        this.dag.edge(edge);
    }
}

