/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.google.common.collect.ImmutableList;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.ValuesLogicalRel;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.plan.node.PlanNodeFieldTypeProvider;
import com.hazelcast.sql.impl.plan.node.PlanNodeSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;

final class ValuesReduceRules {
    static final RelOptRuleOperand REDUCED_VALUES_CHILD_OPERAND = RelOptRule.operand(ReducedLogicalValues.class, (RelOptRuleOperandChildren)RelOptRule.none());
    static final RelOptRule FILTER_INSTANCE = new RelOptRule(RelOptRule.operand(LogicalFilter.class, (RelOptRuleOperand)RelOptRule.operand(LogicalValues.class, (RelOptRuleOperandChildren)RelOptRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, ValuesReduceRules.class.getSimpleName() + "(Filter)"){

        public void onMatch(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            Values values = (Values)call.rel(1);
            ReducedLogicalValues rel = new ReducedLogicalValues(filter.getCluster(), filter.getRowType(), filter.getCondition(), null, values.getTuples());
            call.transformTo((RelNode)rel);
            call.getPlanner().prune((RelNode)filter);
        }
    };
    static final RelOptRule PROJECT_INSTANCE = new RelOptRule(RelOptRule.operand(LogicalProject.class, (RelOptRuleOperand)RelOptRule.operand(LogicalValues.class, (RelOptRuleOperandChildren)RelOptRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, ValuesReduceRules.class.getSimpleName() + "(Project)"){

        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            Values values = (Values)call.rel(1);
            ReducedLogicalValues rel = new ReducedLogicalValues(project.getCluster(), project.getRowType(), null, project.getProjects(), values.getTuples());
            call.transformTo((RelNode)rel);
            call.getPlanner().prune((RelNode)project);
        }
    };
    static final RelOptRule PROJECT_FILTER_INSTANCE = new RelOptRule(RelOptRule.operand(LogicalProject.class, (RelOptRuleOperand)RelOptRule.operand(LogicalFilter.class, (RelOptRuleOperand)RelOptRule.operand(LogicalValues.class, (RelOptRuleOperandChildren)RelOptRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, ValuesReduceRules.class.getSimpleName() + "(Project-Filter)"){

        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            Filter filter = (Filter)call.rel(1);
            Values values = (Values)call.rel(2);
            ReducedLogicalValues rel = new ReducedLogicalValues(project.getCluster(), project.getRowType(), filter.getCondition(), project.getProjects(), values.getTuples());
            call.transformTo((RelNode)rel);
            call.getPlanner().prune((RelNode)project);
        }
    };
    static final RelOptRule UNION_INSTANCE = new RelOptRule(RelOptRule.operand(LogicalUnion.class, (RelOptRuleOperandChildren)RelOptRule.unordered((RelOptRuleOperand)REDUCED_VALUES_CHILD_OPERAND, (RelOptRuleOperand[])new RelOptRuleOperand[0])), RelFactories.LOGICAL_BUILDER, ValuesReduceRules.class.getSimpleName() + "(Union)"){

        public void onMatch(RelOptRuleCall call) {
            Union union = (Union)call.rel(0);
            PlanNodeSchema schema = OptUtils.schema(union.getRowType());
            RexVisitor<Expression<?>> converter = OptUtils.createRexToExpressionVisitor((PlanNodeFieldTypeProvider)schema);
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            for (RelNode input : union.getInputs()) {
                ReducedLogicalValues values = (ReducedLogicalValues)((Object)OptUtils.findMatchingRel(input, REDUCED_VALUES_CHILD_OPERAND));
                RexNode filter = values.filter();
                Expression predicate = filter == null ? null : (Expression)filter.accept(converter);
                List project = values.project();
                List projection = project == null ? null : Util.toList((Collection)project, node -> (Expression)node.accept(converter));
                List<Object[]> row = ExpressionUtil.evaluate((Expression<Boolean>)predicate, projection, OptUtils.convert((ImmutableList<ImmutableList<RexLiteral>>)values.tuples()), ExpressionUtil.NOT_IMPLEMENTED_ARGUMENTS_CONTEXT);
                rows.addAll(row);
            }
            ValuesLogicalRel rel = new ValuesLogicalRel(union.getCluster(), OptUtils.toLogicalConvention(union.getTraitSet()), union.getRowType(), rows);
            call.transformTo((RelNode)rel);
        }
    };

    private ValuesReduceRules() {
    }

    private static final class ReducedLogicalValues
    extends AbstractRelNode {
        private final RelDataType rowType;
        private final RexNode filter;
        private final List<RexNode> project;
        private final ImmutableList<ImmutableList<RexLiteral>> tuples;

        private ReducedLogicalValues(RelOptCluster cluster, RelDataType rowType, RexNode filter, List<RexNode> project, ImmutableList<ImmutableList<RexLiteral>> tuples) {
            super(cluster, cluster.traitSetOf((RelTrait)Convention.NONE));
            this.rowType = rowType;
            this.filter = filter;
            this.project = project;
            this.tuples = tuples;
        }

        private RexNode filter() {
            return this.filter;
        }

        private List<RexNode> project() {
            return this.project;
        }

        private ImmutableList<ImmutableList<RexLiteral>> tuples() {
            return this.tuples;
        }

        protected RelDataType deriveRowType() {
            return this.rowType;
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new ReducedLogicalValues(this.getCluster(), this.rowType, this.filter, this.project, this.tuples);
        }

        public RelWriter explainTerms(RelWriter pw) {
            return pw.item("id", (Object)this.id);
        }
    }
}

