/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.opt.logical.LogicalRel;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.type.RelDataType;

public class ValuesLogicalRel
extends AbstractRelNode
implements LogicalRel {
    private final RelDataType rowType;
    private final List<Object[]> tuples;

    ValuesLogicalRel(RelOptCluster cluster, RelTraitSet traits, RelDataType rowType, List<Object[]> tuples) {
        super(cluster, traits);
        this.rowType = rowType;
        this.tuples = tuples;
    }

    public List<Object[]> tuples() {
        return this.tuples;
    }

    protected RelDataType deriveRowType() {
        return this.rowType;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new ValuesLogicalRel(this.getCluster(), traitSet, this.rowType, this.tuples);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("tuples", (Object)this.tuples.stream().map(row -> Arrays.stream(row).map(String::valueOf).collect(Collectors.joining(", ", "{ ", " }"))).collect(Collectors.joining(", ", "[", "]")));
    }
}

