/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.keyvalue;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.impl.util.ReflectionUtils;
import com.hazelcast.jet.sql.impl.connector.keyvalue.JavaClassNameResolver;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolver;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolvers;
import com.hazelcast.jet.sql.impl.inject.PojoUpsertTargetDescriptor;
import com.hazelcast.jet.sql.impl.inject.PrimitiveUpsertTargetDescriptor;
import com.hazelcast.jet.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.FieldsUtil;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.GenericQueryTargetDescriptor;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Stream;

public final class KvMetadataJavaResolver
implements KvMetadataResolver {
    public static final KvMetadataJavaResolver INSTANCE = new KvMetadataJavaResolver();

    @Override
    public Stream<String> supportedFormats() {
        return Stream.concat(Stream.of("java"), JavaClassNameResolver.formats());
    }

    @Override
    public List<MappingField> resolveAndValidateFields(boolean isKey, List<MappingField> userFields, Map<String, String> options, InternalSerializationService serializationService) {
        Class<?> clazz = this.loadClass(isKey, options);
        return this.resolveFields(isKey, userFields, clazz);
    }

    public List<MappingField> resolveFields(boolean isKey, List<MappingField> userFields, Class<?> clazz) {
        QueryDataType type = QueryDataTypeUtils.resolveTypeForClass(clazz);
        if (type != QueryDataType.OBJECT) {
            return this.resolvePrimitiveSchema(isKey, userFields, type);
        }
        return this.resolveObjectSchema(isKey, userFields, clazz);
    }

    private List<MappingField> resolvePrimitiveSchema(boolean isKey, List<MappingField> userFields, QueryDataType type) {
        String name;
        QueryPath path;
        Map<QueryPath, MappingField> userFieldsByPath = KvMetadataResolvers.extractFields(userFields, isKey);
        MappingField mappingField = userFieldsByPath.get(path = isKey ? QueryPath.KEY_PATH : QueryPath.VALUE_PATH);
        if (mappingField != null && !type.getTypeFamily().equals((Object)mappingField.type().getTypeFamily())) {
            throw QueryException.error((String)("Mismatch between declared and resolved type for field '" + mappingField.name() + "'"));
        }
        String string = mappingField == null ? (isKey ? QueryPath.KEY : QueryPath.VALUE) : (name = mappingField.name());
        if (mappingField == null && userFields.stream().anyMatch(f -> f.name().equals(name))) {
            return Collections.emptyList();
        }
        MappingField field = new MappingField(name, type, path.toString());
        for (MappingField mf : userFieldsByPath.values()) {
            if (field.externalName().equals(mf.externalName())) continue;
            throw QueryException.error((String)("The field '" + field.externalName() + "' is of type " + field.type().getTypeFamily().name() + ", you can't map '" + mf.externalName() + "' too"));
        }
        return Collections.singletonList(field);
    }

    private List<MappingField> resolveObjectSchema(boolean isKey, List<MappingField> userFields, Class<?> clazz) {
        Set fieldsInClass = FieldsUtil.resolveClass(clazz).entrySet();
        Map<QueryPath, MappingField> userFieldsByPath = KvMetadataResolvers.extractFields(userFields, isKey);
        if (!userFields.isEmpty()) {
            for (Map.Entry classField : fieldsInClass) {
                QueryPath path = new QueryPath((String)classField.getKey(), isKey);
                QueryDataType type = QueryDataTypeUtils.resolveTypeForClass((Class)((Class)classField.getValue()));
                MappingField mappingField = userFieldsByPath.get(path);
                if (mappingField == null || type.getTypeFamily().equals((Object)mappingField.type().getTypeFamily())) continue;
                throw QueryException.error((String)("Mismatch between declared and resolved type for field '" + mappingField.name() + "'. Declared: " + mappingField.type().getTypeFamily() + ", resolved: " + type.getTypeFamily()));
            }
            return new ArrayList<MappingField>(userFieldsByPath.values());
        }
        if (fieldsInClass.isEmpty()) {
            String name = isKey ? QueryPath.KEY : QueryPath.VALUE;
            return Collections.singletonList(new MappingField(name, QueryDataType.OBJECT, name));
        }
        ArrayList<MappingField> fields = new ArrayList<MappingField>();
        for (Map.Entry classField : fieldsInClass) {
            QueryPath path = new QueryPath((String)classField.getKey(), isKey);
            QueryDataType type = QueryDataTypeUtils.resolveTypeForClass((Class)((Class)classField.getValue()));
            String name = (String)classField.getKey();
            fields.add(new MappingField(name, type, path.toString()));
        }
        return fields;
    }

    @Override
    public KvMetadata resolveMetadata(boolean isKey, List<MappingField> resolvedFields, Map<String, String> options, InternalSerializationService serializationService) {
        Class<?> clazz = this.loadClass(isKey, options);
        return this.resolveMetadata(isKey, resolvedFields, clazz);
    }

    public KvMetadata resolveMetadata(boolean isKey, List<MappingField> resolvedFields, Class<?> clazz) {
        QueryDataType type = QueryDataTypeUtils.resolveTypeForClass(clazz);
        Map<QueryPath, MappingField> externalFieldsByPath = KvMetadataResolvers.extractFields(resolvedFields, isKey);
        if (type != QueryDataType.OBJECT) {
            return this.resolvePrimitiveMetadata(isKey, externalFieldsByPath);
        }
        return this.resolveObjectMetadata(isKey, resolvedFields, externalFieldsByPath, clazz);
    }

    private KvMetadata resolvePrimitiveMetadata(boolean isKey, Map<QueryPath, MappingField> externalFieldsByPath) {
        QueryPath path = isKey ? QueryPath.KEY_PATH : QueryPath.VALUE_PATH;
        MappingField mappingField = externalFieldsByPath.get(path);
        return new KvMetadata(mappingField != null ? Collections.singletonList(new MapTableField(mappingField.name(), mappingField.type(), false, path)) : Collections.emptyList(), (QueryTargetDescriptor)GenericQueryTargetDescriptor.DEFAULT, PrimitiveUpsertTargetDescriptor.INSTANCE);
    }

    private KvMetadata resolveObjectMetadata(boolean isKey, List<MappingField> resolvedFields, Map<QueryPath, MappingField> externalFieldsByPath, Class<?> clazz) {
        SortedMap typesByNames = FieldsUtil.resolveClass(clazz);
        ArrayList<TableField> fields = new ArrayList<TableField>();
        HashMap<String, String> typeNamesByPaths = new HashMap<String, String>();
        for (Map.Entry<QueryPath, MappingField> entry : externalFieldsByPath.entrySet()) {
            QueryPath path = entry.getKey();
            QueryDataType type = entry.getValue().type();
            String name = entry.getValue().name();
            fields.add((TableField)new MapTableField(name, type, false, path));
            if (path.getPath() == null || typesByNames.get(path.getPath()) == null) continue;
            typeNamesByPaths.put(path.getPath(), ((Class)typesByNames.get(path.getPath())).getName());
        }
        KvMetadataResolvers.maybeAddDefaultField(isKey, resolvedFields, fields);
        return new KvMetadata(fields, (QueryTargetDescriptor)GenericQueryTargetDescriptor.DEFAULT, new PojoUpsertTargetDescriptor(clazz.getName(), typeNamesByPaths));
    }

    private Class<?> loadClass(boolean isKey, Map<String, String> options) {
        String className;
        String formatProperty = options.get(isKey ? "keyFormat" : "valueFormat");
        String classNameProperty = isKey ? "keyJavaClass" : "valueJavaClass";
        String string = className = "java".equals(formatProperty) ? options.get(classNameProperty) : JavaClassNameResolver.resolveClassName(formatProperty);
        if (className == null) {
            throw QueryException.error((String)("Unable to resolve table metadata. Missing '" + classNameProperty + "' option"));
        }
        try {
            return ReflectionUtils.loadClass((String)className);
        }
        catch (Exception e) {
            throw QueryException.error((String)("Unable to load class: '" + className + "'"), (Throwable)e);
        }
    }
}

