/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.sql.impl.parse.ParserResource;
import com.hazelcast.jet.sql.impl.parse.SqlMappingColumn;
import com.hazelcast.jet.sql.impl.parse.SqlOption;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.ImmutableNullableList;

public class SqlCreateMapping
extends SqlCreate {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE EXTERNAL MAPPING", SqlKind.CREATE_TABLE);
    private final SqlIdentifier name;
    private final SqlIdentifier externalName;
    private final SqlNodeList columns;
    private final SqlIdentifier type;
    private final SqlNodeList options;

    public SqlCreateMapping(SqlIdentifier name, SqlIdentifier externalName, SqlNodeList columns, SqlIdentifier type, SqlNodeList options, boolean replace, boolean ifNotExists, SqlParserPos pos) {
        super((SqlOperator)OPERATOR, pos, replace, ifNotExists);
        this.name = Objects.requireNonNull(name, "Name should not be null");
        this.externalName = externalName;
        this.columns = Objects.requireNonNull(columns, "Columns should not be null");
        this.type = Objects.requireNonNull(type, "Type should not be null");
        this.options = Objects.requireNonNull(options, "Options should not be null");
        Preconditions.checkTrue((externalName == null || externalName.isSimple() ? 1 : 0) != 0, (String)(externalName == null ? null : externalName.toString()));
    }

    public String nameWithoutSchema() {
        return (String)this.name.names.get(this.name.names.size() - 1);
    }

    public String externalName() {
        return this.externalName == null ? this.nameWithoutSchema() : this.externalName.getSimple();
    }

    public Stream<SqlMappingColumn> columns() {
        return this.columns.getList().stream().map(node -> (SqlMappingColumn)((Object)node));
    }

    public String type() {
        return this.type.toString();
    }

    public Map<String, String> options() {
        return this.options.getList().stream().map(node -> (SqlOption)((Object)node)).collect(LinkedHashMap::new, (map, option) -> map.putIfAbsent(option.keyString(), option.valueString()), Map::putAll);
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name, (Object)this.columns, (Object)this.type, (Object)this.options);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        if (this.getReplace()) {
            writer.keyword("OR REPLACE");
        }
        writer.keyword("EXTERNAL MAPPING");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.columns.size() > 0) {
            SqlWriter.Frame frame = writer.startList("(", ")");
            for (SqlNode column : this.columns) {
                this.printIndent(writer);
                column.unparse(writer, 0, 0);
            }
            writer.newlineAndIndent();
            writer.endList(frame);
        }
        writer.newlineAndIndent();
        writer.keyword("TYPE");
        this.type.unparse(writer, leftPrec, rightPrec);
        if (this.options.size() > 0) {
            writer.newlineAndIndent();
            writer.keyword("OPTIONS");
            SqlWriter.Frame withFrame = writer.startList("(", ")");
            for (SqlNode property : this.options) {
                this.printIndent(writer);
                property.unparse(writer, leftPrec, rightPrec);
            }
            writer.newlineAndIndent();
            writer.endList(withFrame);
        }
    }

    private void printIndent(SqlWriter writer) {
        writer.sep(",", false);
        writer.newlineAndIndent();
        writer.print("  ");
    }

    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        if (this.getReplace() && this.ifNotExists) {
            throw validator.newValidationError((SqlNode)this, ParserResource.RESOURCE.orReplaceWithIfNotExistsNotSupported());
        }
        if (!SqlCreateMapping.isMappingNameValid(this.name)) {
            throw validator.newValidationError((SqlNode)this.name, ParserResource.RESOURCE.mappingIncorrectSchema());
        }
        HashSet<String> columnNames = new HashSet<String>();
        for (SqlNode column : this.columns.getList()) {
            String name = ((SqlMappingColumn)column).name();
            if (columnNames.add(name)) continue;
            throw validator.newValidationError(column, ParserResource.RESOURCE.duplicateColumn(name));
        }
        HashSet<String> optionNames = new HashSet<String>();
        for (SqlNode option : this.options.getList()) {
            String name = ((SqlOption)option).keyString();
            if (optionNames.add(name)) continue;
            throw validator.newValidationError(option, ParserResource.RESOURCE.duplicateOption(name));
        }
    }

    public static boolean isMappingNameValid(SqlIdentifier name) {
        return name.names.size() == 1 || name.names.size() == 2 && "public".equals(name.names.get(0)) || name.names.size() == 3 && "hazelcast".equals(name.names.get(0)) && "public".equals(name.names.get(1));
    }
}

