/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.sql.impl.opt.JetConventions;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.JoinLogicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.JoinNestedLoopPhysicalRel;
import java.util.Collection;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;

public final class JoinPhysicalRule
extends RelOptRule {
    static final RelOptRule INSTANCE = new JoinPhysicalRule();

    private JoinPhysicalRule() {
        super(JoinPhysicalRule.operand(JoinLogicalRel.class, (RelTrait)JetConventions.LOGICAL, (RelOptRuleOperandChildren)JoinPhysicalRule.some((RelOptRuleOperand)JoinPhysicalRule.operand(RelNode.class, (RelOptRuleOperandChildren)JoinPhysicalRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[]{JoinPhysicalRule.operand(RelNode.class, (RelOptRuleOperandChildren)JoinPhysicalRule.any())})), JoinPhysicalRule.class.getSimpleName());
    }

    public void onMatch(RelOptRuleCall call) {
        JoinLogicalRel logicalJoin = (JoinLogicalRel)call.rel(0);
        JoinRelType joinType = logicalJoin.getJoinType();
        assert (joinType == JoinRelType.INNER || joinType == JoinRelType.LEFT);
        RelNode physicalLeft = OptUtils.toPhysicalInput(logicalJoin.getLeft());
        RelNode physicalRight = OptUtils.toPhysicalInput(logicalJoin.getRight());
        Collection<RelNode> lefts = OptUtils.extractPhysicalRelsFromSubset(physicalLeft);
        Collection<RelNode> rights = OptUtils.extractPhysicalRelsFromSubset(physicalRight);
        for (RelNode left : lefts) {
            for (RelNode right : rights) {
                JoinNestedLoopPhysicalRel rel = new JoinNestedLoopPhysicalRel(logicalJoin.getCluster(), OptUtils.toPhysicalConvention(logicalJoin.getTraitSet()), left, right, logicalJoin.getCondition(), logicalJoin.getJoinType());
                call.transformTo((RelNode)rel);
            }
        }
    }
}

