/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.kafka;

import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.kafka.PropertiesResolver;
import com.hazelcast.jet.sql.impl.inject.UpsertTargetDescriptor;
import com.hazelcast.jet.sql.impl.schema.JetTable;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableStatistics;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.List;
import java.util.Map;
import java.util.Properties;

class KafkaTable
extends JetTable {
    private final QueryTargetDescriptor keyQueryDescriptor;
    private final UpsertTargetDescriptor keyUpsertDescriptor;
    private final QueryTargetDescriptor valueQueryDescriptor;
    private final UpsertTargetDescriptor valueUpsertDescriptor;
    private final String topicName;
    private final Map<String, String> options;

    KafkaTable(SqlConnector sqlConnector, String schemaName, String name, List<TableField> fields, TableStatistics statistics, String topicName, Map<String, String> options, QueryTargetDescriptor keyQueryDescriptor, UpsertTargetDescriptor keyUpsertDescriptor, QueryTargetDescriptor valueQueryDescriptor, UpsertTargetDescriptor valueUpsertDescriptor) {
        super(sqlConnector, fields, schemaName, name, statistics);
        this.keyQueryDescriptor = keyQueryDescriptor;
        this.keyUpsertDescriptor = keyUpsertDescriptor;
        this.valueQueryDescriptor = valueQueryDescriptor;
        this.valueUpsertDescriptor = valueUpsertDescriptor;
        this.topicName = topicName;
        this.options = options;
    }

    String topicName() {
        return this.topicName;
    }

    Properties kafkaConsumerProperties() {
        return PropertiesResolver.resolveConsumerProperties(this.options);
    }

    Properties kafkaProducerProperties() {
        return PropertiesResolver.resolveProducerProperties(this.options);
    }

    QueryTargetDescriptor keyQueryDescriptor() {
        return this.keyQueryDescriptor;
    }

    UpsertTargetDescriptor keyUpsertDescriptor() {
        return this.keyUpsertDescriptor;
    }

    QueryTargetDescriptor valueQueryDescriptor() {
        return this.valueQueryDescriptor;
    }

    UpsertTargetDescriptor valueUpsertDescriptor() {
        return this.valueUpsertDescriptor;
    }

    QueryPath[] paths() {
        return (QueryPath[])this.getFields().stream().map(field -> ((MapTableField)field).getPath()).toArray(QueryPath[]::new);
    }

    QueryDataType[] types() {
        return (QueryDataType[])this.getFields().stream().map(TableField::getType).toArray(QueryDataType[]::new);
    }
}

