/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.generator;

import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.impl.pipeline.transform.BatchSourceTransform;
import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.generator.SeriesTable;
import com.hazelcast.jet.sql.impl.schema.MappingField;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class SeriesSqlConnector
implements SqlConnector {
    static final SeriesSqlConnector INSTANCE = new SeriesSqlConnector();
    private static final String TYPE_NAME = "Series";
    private static final List<TableField> FIELDS = Collections.singletonList(new TableField("v", QueryDataType.INT, false));

    SeriesSqlConnector() {
    }

    @Override
    public String typeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isStream() {
        return false;
    }

    @Override
    @Nonnull
    public List<MappingField> resolveAndValidateFields(@Nonnull NodeEngine nodeEngine, @Nonnull Map<String, String> options, @Nonnull List<MappingField> userFields) {
        throw new UnsupportedOperationException("Resolving fields not supported for " + this.typeName());
    }

    @Override
    @Nonnull
    public Table createTable(@Nonnull NodeEngine nodeEngine, @Nonnull String schemaName, @Nonnull String name, @Nonnull String externalName, @Nonnull Map<String, String> options, @Nonnull List<MappingField> resolvedFields) {
        throw new UnsupportedOperationException("Creating table not supported for " + this.typeName());
    }

    @Nonnull
    static SeriesTable createTable(String schemaName, String name, Integer start, Integer stop, Integer step) {
        return new SeriesTable(INSTANCE, FIELDS, schemaName, name, start, stop, step);
    }

    @Override
    public boolean supportsFullScanReader() {
        return true;
    }

    @Override
    @Nonnull
    public Vertex fullScanReader(@Nonnull DAG dag, @Nonnull Table table0, @Nullable Expression<Boolean> predicate, @Nonnull List<Expression<?>> projections) {
        SeriesTable table = (SeriesTable)table0;
        BatchSource<Object[]> source = table.items(predicate, projections);
        ProcessorMetaSupplier pms = ((BatchSourceTransform)source).metaSupplier;
        return dag.newUniqueVertex(table.toString(), pms);
    }
}

