/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate.function;

import com.hazelcast.sql.impl.ParameterConverter;
import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.operators.ReplaceUnknownOperandTypeInference;
import com.hazelcast.sql.impl.calcite.validate.operators.common.HazelcastAggFunction;
import com.hazelcast.sql.impl.calcite.validate.param.NoOpParameterConverter;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastIntegerType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Optionality;

public class HazelcastCountAggFunction
extends HazelcastAggFunction {
    public HazelcastCountAggFunction() {
        super("COUNT", SqlKind.COUNT, opBinding -> HazelcastIntegerType.create((int)64, (boolean)false), (SqlOperandTypeInference)new IgnoreCountStarOperandTypeInference((SqlOperandTypeInference)new ReplaceUnknownOperandTypeInference(SqlTypeName.BIGINT)), null, SqlFunctionCategory.NUMERIC, false, false, Optionality.FORBIDDEN);
    }

    public SqlSyntax getSyntax() {
        return SqlSyntax.FUNCTION_STAR;
    }

    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        return HazelcastIntegerType.create((int)64, (boolean)false);
    }

    protected boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure) {
        SqlNode node = binding.operand(0);
        if (node.getKind() == SqlKind.DYNAMIC_PARAM) {
            int parameterIndex = ((SqlDynamicParam)node).getIndex();
            binding.getValidator().setParameterConverter(parameterIndex, (ParameterConverter)NoOpParameterConverter.INSTANCE);
        }
        return true;
    }

    private static class IgnoreCountStarOperandTypeInference
    implements SqlOperandTypeInference {
        private final SqlOperandTypeInference delegate;

        IgnoreCountStarOperandTypeInference(SqlOperandTypeInference delegate) {
            this.delegate = delegate;
        }

        public void inferOperandTypes(SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) {
            if (callBinding.getCall().isCountStar()) {
                return;
            }
            this.delegate.inferOperandTypes(callBinding, returnType, operandTypes);
        }
    }
}

