/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.generator;

import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.jet.sql.impl.connector.generator.SeriesSqlConnector;
import com.hazelcast.jet.sql.impl.connector.generator.SeriesTable;
import com.hazelcast.jet.sql.impl.schema.JetSpecificTableFunction;
import com.hazelcast.jet.sql.impl.validate.ValidationUtil;
import com.hazelcast.jet.sql.impl.validate.operand.NamedOperandCheckerProgram;
import com.hazelcast.jet.sql.impl.validate.operators.HazelcastOperandTypeInference;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTableStatistic;
import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.operand.OperandChecker;
import com.hazelcast.sql.impl.calcite.validate.operand.OperandCheckerProgram;
import com.hazelcast.sql.impl.calcite.validate.operand.TypedOperandChecker;
import com.hazelcast.sql.impl.calcite.validate.operators.ReplaceUnknownOperandTypeInference;
import com.hazelcast.sql.impl.schema.Table;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;

public final class SeriesGeneratorTableFunction
extends JetSpecificTableFunction {
    private static final String SCHEMA_NAME_SERIES = "series";
    private static final String FUNCTION_NAME = "GENERATE_SERIES";
    private static final List<String> PARAM_NAMES = Arrays.asList("start", "stop", "step");

    public SeriesGeneratorTableFunction() {
        super(FUNCTION_NAME, binding -> SeriesGeneratorTableFunction.toTable(0, 0, 1).getRowType(binding.getTypeFactory()), new HazelcastOperandTypeInference(new SqlTypeName[]{SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER}, (SqlOperandTypeInference)new ReplaceUnknownOperandTypeInference(SqlTypeName.INTEGER)), SeriesSqlConnector.INSTANCE);
    }

    public List<String> getParamNames() {
        return PARAM_NAMES;
    }

    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.between((int)2, (int)3);
    }

    protected boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure) {
        if (ValidationUtil.hasAssignment(binding.getCall())) {
            return new NamedOperandCheckerProgram(new OperandChecker[]{TypedOperandChecker.INTEGER, TypedOperandChecker.INTEGER, TypedOperandChecker.INTEGER}).check(binding, throwOnFailure);
        }
        if (binding.getOperandCount() == 3) {
            return new OperandCheckerProgram(new OperandChecker[]{TypedOperandChecker.INTEGER, TypedOperandChecker.INTEGER, TypedOperandChecker.INTEGER}).check(binding, throwOnFailure);
        }
        assert (binding.getOperandCount() == 2);
        return new OperandCheckerProgram(new OperandChecker[]{TypedOperandChecker.INTEGER, TypedOperandChecker.INTEGER}).check(binding, throwOnFailure);
    }

    @Override
    public HazelcastTable toTable(List<Object> arguments) {
        Integer start = (Integer)arguments.get(0);
        Integer stop = (Integer)arguments.get(1);
        Integer step = arguments.get(2) != null ? (Integer)arguments.get(2) : 1;
        return SeriesGeneratorTableFunction.toTable(start, stop, step);
    }

    private static HazelcastTable toTable(Integer start, Integer stop, Integer step) {
        SeriesTable table = SeriesSqlConnector.createTable(SCHEMA_NAME_SERIES, SeriesGeneratorTableFunction.randomName(), start, stop, step);
        return new HazelcastTable((Table)table, (Statistic)new HazelcastTableStatistic(table.numberOfItems()));
    }

    private static String randomName() {
        return "series_" + UuidUtil.newUnsecureUuidString().replace('-', '_');
    }
}

