/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate.function;

import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.operand.TypedOperandChecker;
import com.hazelcast.sql.impl.calcite.validate.operators.ReplaceUnknownOperandTypeInference;
import com.hazelcast.sql.impl.calcite.validate.operators.common.HazelcastAggFunction;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeFactory;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Optionality;

public class HazelcastAvgAggFunction
extends HazelcastAggFunction {
    public HazelcastAvgAggFunction() {
        super("AVG", SqlKind.AVG, ReturnTypes.AVG_AGG_FUNCTION, (SqlOperandTypeInference)new ReplaceUnknownOperandTypeInference(SqlTypeName.BIGINT), null, SqlFunctionCategory.NUMERIC, false, false, Optionality.FORBIDDEN);
    }

    protected boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure) {
        RelDataType operandType = binding.getOperandType(0);
        if (!HazelcastTypeUtils.isNumericType((RelDataType)operandType)) {
            if (throwOnFailure) {
                throw binding.newValidationSignatureError();
            }
            return false;
        }
        RelDataType resultType = HazelcastTypeUtils.isNumericIntegerType((RelDataType)operandType) || operandType.getSqlTypeName() == SqlTypeName.DECIMAL ? HazelcastTypeFactory.INSTANCE.createSqlType(SqlTypeName.DECIMAL) : HazelcastTypeFactory.INSTANCE.createSqlType(SqlTypeName.DOUBLE);
        TypedOperandChecker checker = TypedOperandChecker.forType((RelDataType)resultType);
        assert (checker.isNumeric());
        return checker.check(binding, throwOnFailure, 0);
    }
}

