/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.jet.sql.impl.parse.ParserResource;
import com.hazelcast.jet.sql.impl.parse.SqlCreateMapping;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.calcite.sql.SqlDrop;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.ImmutableNullableList;

public class SqlDropMapping
extends SqlDrop {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("DROP EXTERNAL MAPPING", SqlKind.DROP_TABLE);
    private final SqlIdentifier name;

    public SqlDropMapping(SqlIdentifier name, boolean ifExists, SqlParserPos pos) {
        super((SqlOperator)OPERATOR, pos, ifExists);
        this.name = Objects.requireNonNull(name, "Name should not be null");
    }

    public String nameWithoutSchema() {
        return (String)this.name.names.get(this.name.names.size() - 1);
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DROP EXTERNAL MAPPING");
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
    }

    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        if (!SqlCreateMapping.isMappingNameValid(this.name)) {
            throw validator.newValidationError((SqlNode)this.name, ParserResource.RESOURCE.droppedMappingDoesNotExist(this.name.toString()));
        }
    }
}

