/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.sql.impl.parse.ParserResource;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.ImmutableNullableList;

public class SqlCreateSnapshot
extends SqlCreate {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE SNAPSHOT", SqlKind.OTHER_DDL);
    private final SqlIdentifier snapshotName;
    private final SqlIdentifier jobName;

    public SqlCreateSnapshot(SqlIdentifier snapshotName, SqlIdentifier jobName, boolean replace, SqlParserPos pos) {
        super((SqlOperator)OPERATOR, pos, replace, false);
        this.snapshotName = Objects.requireNonNull(snapshotName, "Snapshot name must not be null");
        this.jobName = Objects.requireNonNull(jobName, "Job name must not be null");
        Preconditions.checkTrue((boolean)snapshotName.isSimple(), (String)snapshotName.toString());
        Preconditions.checkTrue((boolean)jobName.isSimple(), (String)jobName.toString());
    }

    public String getSnapshotName() {
        return this.snapshotName.toString();
    }

    public String getJobName() {
        return this.jobName.toString();
    }

    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.snapshotName, (Object)this.jobName);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        if (this.getReplace()) {
            writer.keyword("OR REPLACE");
        }
        writer.keyword("SNAPSHOT");
        this.snapshotName.unparse(writer, leftPrec, rightPrec);
        writer.keyword("FOR JOB");
        this.jobName.unparse(writer, leftPrec, rightPrec);
    }

    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        if (!this.getReplace()) {
            throw validator.newValidationError((SqlNode)this, ParserResource.RESOURCE.createSnapshotWithoutReplace());
        }
    }
}

