/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.extract;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.QueryExtractor;
import com.hazelcast.sql.impl.extract.QueryTarget;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeMismatchException;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class HazelcastJsonQueryTarget
implements QueryTarget {
    private final SerializationService serializationService;
    private final Extractors extractors;
    private final boolean key;
    private Object target;

    HazelcastJsonQueryTarget(SerializationService serializationService, Extractors extractors, boolean key) {
        this.serializationService = serializationService;
        this.extractors = extractors;
        this.key = key;
    }

    public void setTarget(Object target, Data targetData) {
        if (target == null && targetData != null) {
            target = this.serializationService.toObject((Object)targetData);
        }
        this.target = target;
    }

    public QueryExtractor createExtractor(String path, QueryDataType type) {
        return path == null ? this.createExtractor(type) : this.createFieldExtractor(path, type);
    }

    private QueryExtractor createExtractor(QueryDataType type) {
        return () -> {
            try {
                Object value = this.serializationService.toObject(this.target);
                return type.convert(value);
            }
            catch (QueryDataTypeMismatchException e) {
                throw QueryException.dataException((String)("Failed to extract map entry " + (this.key ? "key" : "value") + " because of type mismatch [expectedClass=" + e.getExpectedClass().getName() + ", actualClass=" + e.getActualClass().getName() + ']')).markInvalidate();
            }
            catch (Exception e) {
                throw QueryException.dataException((String)("Failed to extract map entry " + (this.key ? "key" : "value") + ": " + e.getMessage()), (Throwable)e);
            }
        };
    }

    private QueryExtractor createFieldExtractor(String path, QueryDataType type) {
        return () -> {
            try {
                Object value = this.extractors.extract(this.target, path, null, false);
                return type.convert(value);
            }
            catch (QueryDataTypeMismatchException e) {
                throw QueryException.dataException((String)("Failed to extract map entry " + (this.key ? "key" : "value") + " field \"" + path + "\" because of type mismatch [expectedClass=" + e.getExpectedClass().getName() + ", actualClass=" + e.getActualClass().getName() + ']')).markInvalidate();
            }
            catch (Exception e) {
                throw QueryException.dataException((String)("Failed to extract map entry " + (this.key ? "key" : "value") + " field \"" + path + "\": " + e.getMessage()), (Throwable)e);
            }
        };
    }
}

