/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.file;

import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.pipeline.file.CsvFileFormat;
import com.hazelcast.jet.pipeline.file.FileFormat;
import com.hazelcast.jet.sql.impl.connector.file.CsvResolver;
import com.hazelcast.jet.sql.impl.connector.file.Metadata;
import com.hazelcast.jet.sql.impl.connector.file.MetadataResolver;
import com.hazelcast.jet.sql.impl.extract.CsvQueryTarget;
import com.hazelcast.jet.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.extract.QueryTarget;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

final class CsvMetadataResolver
extends MetadataResolver<Map<String, String>> {
    static final CsvMetadataResolver INSTANCE = new CsvMetadataResolver();
    private static final FileFormat<?> SAMPLE_FORMAT = FileFormat.csv(Map.class);

    CsvMetadataResolver() {
    }

    @Override
    protected FileFormat<?> sampleFormat() {
        return SAMPLE_FORMAT;
    }

    @Override
    protected List<MappingField> resolveFieldsFromSample(Map<String, String> sample) {
        return CsvResolver.resolveFields(sample.keySet());
    }

    @Override
    protected Metadata resolveMetadata(List<MappingField> resolvedFields, Map<String, ?> options) {
        List<String> fieldNames = CsvMetadataResolver.createFieldList(resolvedFields);
        CsvFileFormat format = FileFormat.csv(CsvMetadataResolver.createFieldList(resolvedFields));
        return new Metadata(this.toFields(resolvedFields), this.toProcessorMetaSupplierProvider(options, (FileFormat<?>)format), (SupplierEx<QueryTarget>)(SupplierEx & Serializable)() -> new CsvQueryTarget(fieldNames));
    }

    @Nonnull
    private static List<String> createFieldList(List<MappingField> resolvedFields) {
        return resolvedFields.stream().map(field -> field.externalName() != null ? field.externalName() : field.name()).distinct().collect(Collectors.toList());
    }
}

