/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector;

import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.schema.MappingField;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.schema.Table;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface SqlConnector {
    public static final String OPTION_FORMAT = "format";
    public static final String OPTION_KEY_FORMAT = "keyFormat";
    public static final String OPTION_VALUE_FORMAT = "valueFormat";
    public static final String OPTION_KEY_CLASS = "keyJavaClass";
    public static final String OPTION_VALUE_CLASS = "valueJavaClass";
    public static final String OPTION_KEY_FACTORY_ID = "keyPortableFactoryId";
    public static final String OPTION_KEY_CLASS_ID = "keyPortableClassId";
    public static final String OPTION_KEY_CLASS_VERSION = "keyPortableClassVersion";
    public static final String OPTION_VALUE_FACTORY_ID = "valuePortableFactoryId";
    public static final String OPTION_VALUE_CLASS_ID = "valuePortableClassId";
    public static final String OPTION_VALUE_CLASS_VERSION = "valuePortableClassVersion";
    public static final String JAVA_FORMAT = "java";
    public static final String PORTABLE_FORMAT = "portable";
    public static final String JSON_FORMAT = "json";
    public static final String CSV_FORMAT = "csv";
    public static final String AVRO_FORMAT = "avro";
    public static final String PARQUET_FORMAT = "parquet";

    public String typeName();

    public boolean isStream();

    @Nonnull
    public List<MappingField> resolveAndValidateFields(@Nonnull NodeEngine var1, @Nonnull Map<String, String> var2, @Nonnull List<MappingField> var3);

    @Nonnull
    public Table createTable(@Nonnull NodeEngine var1, @Nonnull String var2, @Nonnull String var3, @Nonnull String var4, @Nonnull Map<String, String> var5, @Nonnull List<MappingField> var6);

    default public boolean supportsFullScanReader() {
        return false;
    }

    @Nonnull
    default public Vertex fullScanReader(@Nonnull DAG dag, @Nonnull Table table, @Nullable Expression<Boolean> predicate, @Nonnull List<Expression<?>> projection) {
        if (!1.$assertionsDisabled && this.supportsFullScanReader()) {
            throw new AssertionError();
        }
        throw new UnsupportedOperationException("Full scan not supported for " + this.typeName());
    }

    default public boolean supportsNestedLoopReader() {
        return false;
    }

    @Nonnull
    default public VertexWithInputConfig nestedLoopReader(@Nonnull DAG dag, @Nonnull Table table, @Nullable Expression<Boolean> predicate, @Nonnull List<Expression<?>> projection, @Nonnull JetJoinInfo joinInfo) {
        if (!1.$assertionsDisabled && this.supportsNestedLoopReader()) {
            throw new AssertionError();
        }
        throw new UnsupportedOperationException("Join not supported for " + this.typeName());
    }

    default public boolean supportsSink() {
        return false;
    }

    default public boolean supportsInsert() {
        return false;
    }

    @Nonnull
    default public Vertex sink(@Nonnull DAG dag, @Nonnull Table table) {
        if (!1.$assertionsDisabled && this.supportsSink()) {
            throw new AssertionError();
        }
        throw new UnsupportedOperationException("Sink not supported for " + this.typeName());
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static class VertexWithInputConfig {
        private final Vertex vertex;
        private final Consumer<Edge> configureEdgeFn;

        public VertexWithInputConfig(Vertex vertex) {
            this(vertex, null);
        }

        public VertexWithInputConfig(Vertex vertex, Consumer<Edge> configureEdgeFn) {
            this.vertex = vertex;
            this.configureEdgeFn = configureEdgeFn;
        }

        public Vertex vertex() {
            return this.vertex;
        }

        public Consumer<Edge> configureEdgeFn() {
            return this.configureEdgeFn;
        }
    }
}

