/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.internal.util.Preconditions;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.calcite.sql.SqlDrop;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.ImmutableNullableList;

public class SqlDropSnapshot
extends SqlDrop {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("DROP SNAPSHOT", SqlKind.OTHER_DDL);
    private final SqlIdentifier snapshotName;
    private final boolean ifExists;

    public SqlDropSnapshot(SqlIdentifier snapshotName, boolean ifExists, SqlParserPos pos) {
        super((SqlOperator)OPERATOR, pos, true);
        this.snapshotName = Objects.requireNonNull(snapshotName, "Snapshot name must not be null");
        this.ifExists = ifExists;
        Preconditions.checkTrue((snapshotName.names.size() == 1 ? 1 : 0) != 0, (String)snapshotName.toString());
    }

    public String getSnapshotName() {
        return this.snapshotName.toString();
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.snapshotName);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DROP SNAPSHOT");
        this.snapshotName.unparse(writer, leftPrec, rightPrec);
    }

    public void validate(SqlValidator validator, SqlValidatorScope scope) {
    }
}

