/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt;

import com.google.common.collect.ImmutableList;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.opt.JetConventions;
import com.hazelcast.jet.sql.impl.schema.JetTable;
import com.hazelcast.sql.impl.ParameterConverter;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.calcite.opt.physical.visitor.RexToExpression;
import com.hazelcast.sql.impl.calcite.opt.physical.visitor.RexToExpressionVisitor;
import com.hazelcast.sql.impl.calcite.schema.HazelcastRelOptTable;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.plan.node.PlanNodeFieldTypeProvider;
import com.hazelcast.sql.impl.plan.node.PlanNodeSchema;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.type.SqlTypeName;

public final class OptUtils {
    private OptUtils() {
    }

    public static RelTraitSet toLogicalConvention(RelTraitSet traitSet) {
        return OptUtils.traitPlus(traitSet, (RelTrait)JetConventions.LOGICAL);
    }

    public static RelNode toLogicalInput(RelNode rel) {
        return RelOptRule.convert((RelNode)rel, (RelTraitSet)OptUtils.toLogicalConvention(rel.getTraitSet()));
    }

    public static RelTraitSet toPhysicalConvention(RelTraitSet traitSet) {
        return OptUtils.traitPlus(traitSet, (RelTrait)JetConventions.PHYSICAL);
    }

    public static RelNode toPhysicalInput(RelNode rel) {
        return RelOptRule.convert((RelNode)rel, (RelTraitSet)OptUtils.toPhysicalConvention(rel.getTraitSet()));
    }

    public static RelTraitSet traitPlus(RelTraitSet traitSet, RelTrait trait) {
        return traitSet.plus(trait).simplify();
    }

    public static LogicalTableScan createLogicalScan(RelOptCluster cluster, HazelcastTable hazelcastTable) {
        JetTable table = (JetTable)hazelcastTable.getTarget();
        HazelcastRelOptTable relTable = OptUtils.createRelTable(table.getQualifiedName(), hazelcastTable, cluster.getTypeFactory());
        return LogicalTableScan.create((RelOptCluster)cluster, (RelOptTable)relTable, (List)ImmutableList.of());
    }

    private static HazelcastRelOptTable createRelTable(List<String> names, HazelcastTable hazelcastTable, RelDataTypeFactory typeFactory) {
        RelDataType rowType = hazelcastTable.getRowType(typeFactory);
        RelOptTableImpl relTable = RelOptTableImpl.create(null, (RelDataType)rowType, names, (Table)hazelcastTable, null);
        return new HazelcastRelOptTable((Prepare.PreparingTable)relTable);
    }

    public static Collection<RelNode> extractPhysicalRelsFromSubset(RelNode node) {
        if (node instanceof RelSubset) {
            RelSubset subset = (RelSubset)node;
            HashSet<RelTraitSet> traitSets = new HashSet<RelTraitSet>();
            Set<RelNode> result = Collections.newSetFromMap(new IdentityHashMap());
            for (RelNode rel : subset.getRelList()) {
                if (!OptUtils.isPhysical(rel) || !traitSets.add(rel.getTraitSet())) continue;
                result.add(RelOptRule.convert((RelNode)node, (RelTraitSet)rel.getTraitSet()));
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static boolean isPhysical(RelNode rel) {
        return ((Convention)rel.getTraitSet().getTrait((RelTraitDef)ConventionTraitDef.INSTANCE)).equals(JetConventions.PHYSICAL);
    }

    @Nonnull
    public static <T> T findMatchingRel(RelNode node, RelOptRuleOperand operandPredicate) {
        if (node instanceof RelSubset) {
            RelNode res = null;
            for (RelNode rel : ((RelSubset)node).getRels()) {
                if (!operandPredicate.matches(rel)) continue;
                if (res != null) {
                    throw new RuntimeException("multiple matches found");
                }
                res = rel;
            }
            if (res != null) {
                return (T)res;
            }
        } else if (operandPredicate.matches(node)) {
            return (T)node;
        }
        throw new RuntimeException("expected rel not found: " + node);
    }

    public static PlanNodeSchema schema(RelOptTable relTable) {
        com.hazelcast.sql.impl.schema.Table table = ((HazelcastTable)relTable.unwrap(HazelcastTable.class)).getTarget();
        ArrayList<QueryDataType> fieldTypes = new ArrayList<QueryDataType>();
        for (TableField field : table.getFields()) {
            fieldTypes.add(field.getType());
        }
        return new PlanNodeSchema(fieldTypes);
    }

    public static PlanNodeSchema schema(RelDataType rowType) {
        return new PlanNodeSchema(OptUtils.extractFieldTypes(rowType));
    }

    public static RexVisitor<Expression<?>> createRexToExpressionVisitor(PlanNodeFieldTypeProvider schema) {
        return new RexToExpressionVisitor(schema, new QueryParameterMetadata(new ParameterConverter[0]));
    }

    public static List<Object[]> convert(ImmutableList<ImmutableList<RexLiteral>> values) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>(values.size());
        for (List tuple : values) {
            Object[] result = new Object[tuple.size()];
            for (int i = 0; i < tuple.size(); ++i) {
                Object value;
                RexLiteral literal = (RexLiteral)tuple.get(i);
                Expression expression = RexToExpression.convertLiteral((RexLiteral)literal);
                result[i] = value = expression.eval(null, null);
            }
            rows.add(result);
        }
        return rows;
    }

    public static RelDataType convert(TableField field, RelDataTypeFactory typeFactory) {
        QueryDataType fieldType = field.getType();
        SqlTypeName sqlTypeName = HazelcastTypeUtils.toCalciteType((QueryDataType)fieldType);
        if (sqlTypeName == null) {
            throw new IllegalStateException("Unexpected type family: " + fieldType);
        }
        RelDataType relType = typeFactory.createSqlType(sqlTypeName);
        return typeFactory.createTypeWithNullability(relType, true);
    }

    private static List<QueryDataType> extractFieldTypes(RelDataType rowType) {
        return Util.toList((Collection)rowType.getFieldList(), f -> HazelcastTypeUtils.toHazelcastType((SqlTypeName)f.getType().getSqlTypeName()));
    }
}

