/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;

public final class ObjectArrayKey
implements DataSerializable {
    private Object[] array;

    private ObjectArrayKey() {
    }

    private ObjectArrayKey(Object[] array) {
        this.array = array;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject((Object)this.array);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.array = (Object[])in.readObject();
    }

    public String toString() {
        return "ObjectArray{array=" + Arrays.toString(this.array) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectArrayKey that = (ObjectArrayKey)o;
        return Arrays.equals(this.array, that.array);
    }

    public int hashCode() {
        return Arrays.hashCode(this.array);
    }

    public static FunctionEx<Object[], ObjectArrayKey> projectFn(int[] indices) {
        return (FunctionEx & Serializable)row -> {
            Object[] key = new Object[indices.length];
            for (int i = 0; i < indices.length; ++i) {
                key[i] = row[indices[i]];
            }
            return new ObjectArrayKey(key);
        };
    }
}

