/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate;

import com.hazelcast.jet.sql.impl.parse.SqlAlterJob;
import com.hazelcast.jet.sql.impl.parse.SqlCreateJob;
import com.hazelcast.jet.sql.impl.parse.SqlCreateSnapshot;
import com.hazelcast.jet.sql.impl.parse.SqlDropJob;
import com.hazelcast.jet.sql.impl.parse.SqlDropSnapshot;
import com.hazelcast.jet.sql.impl.parse.SqlOption;
import com.hazelcast.jet.sql.impl.parse.SqlShowStatement;
import com.hazelcast.jet.sql.impl.validate.JetSqlOperatorTable;
import com.hazelcast.jet.sql.impl.validate.ValidatorResource;
import com.hazelcast.sql.impl.calcite.validate.HazelcastSqlOperatorTable;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeSystem;
import java.util.HashSet;
import java.util.Set;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.SqlUserDefinedTypeNameSpec;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlValidatorException;

public final class UnsupportedOperationVisitor
extends SqlBasicVisitor<Void> {
    public static final UnsupportedOperationVisitor INSTANCE = new UnsupportedOperationVisitor();
    private static final Set<SqlKind> SUPPORTED_KINDS = new HashSet<SqlKind>();
    private static final Set<SqlOperator> SUPPORTED_OPERATORS;
    private static final Set<SqlOperator> SUPPORTED_FUNCTIONS;

    private UnsupportedOperationVisitor() {
    }

    public Void visit(SqlCall call) {
        if (!SUPPORTED_FUNCTIONS.contains(call.getOperator())) {
            this.processCall(call);
            call.getOperator().acceptCall((SqlVisitor)this, call);
        }
        return null;
    }

    public Void visit(SqlDataTypeSpec type) {
        SqlIdentifier typeName;
        if (type.getTypeNameSpec() instanceof SqlUserDefinedTypeNameSpec && (HazelcastTypeSystem.isObject((SqlIdentifier)(typeName = type.getTypeName())) || HazelcastTypeSystem.isTimestampWithTimeZone((SqlIdentifier)typeName))) {
            return null;
        }
        if (!(type.getTypeNameSpec() instanceof SqlBasicTypeNameSpec)) {
            throw this.error((SqlNode)type, ValidatorResource.RESOURCE.error("Complex type specifications are not supported"));
        }
        typeName = SqlTypeName.get((String)type.getTypeName().getSimple());
        switch (1.$SwitchMap$org$apache$calcite$sql$type$SqlTypeName[typeName.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return null;
            }
        }
        throw this.error((SqlNode)type, ValidatorResource.RESOURCE.notSupported(typeName.getName()));
    }

    public Void visit(SqlLiteral literal) {
        SqlTypeName typeName = literal.getTypeName();
        switch (typeName) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DECIMAL: 
            case REAL: 
            case DOUBLE: 
            case VARCHAR: 
            case NULL: 
            case CHAR: 
            case ANY: {
                return null;
            }
            case SYMBOL: {
                Object symbolValue = literal.getValue();
                if (symbolValue instanceof SqlTrimFunction.Flag) {
                    return null;
                }
                if (symbolValue == SqlSelectKeyword.DISTINCT || symbolValue == SqlSelectKeyword.ALL) {
                    return null;
                }
                if (symbolValue == JoinType.INNER || symbolValue == JoinType.COMMA || symbolValue == JoinType.CROSS || symbolValue == JoinType.LEFT) {
                    return null;
                }
                if (symbolValue == JoinConditionType.ON || symbolValue == JoinConditionType.NONE || symbolValue == JoinConditionType.USING) {
                    return null;
                }
                throw this.error((SqlNode)literal, ValidatorResource.RESOURCE.error(symbolValue + " literal is not supported"));
            }
        }
        throw this.error((SqlNode)literal, ValidatorResource.RESOURCE.error(typeName + " literals are not supported"));
    }

    private void processCall(SqlCall call) {
        SqlKind kind = call.getKind();
        if (SUPPORTED_KINDS.contains(kind)) {
            return;
        }
        switch (kind) {
            case SELECT: {
                this.processSelect((SqlSelect)call);
                break;
            }
            case JOIN: {
                this.processJoin((SqlJoin)call);
                break;
            }
            case OTHER: 
            case OTHER_FUNCTION: {
                this.processOther(call);
                break;
            }
            case OTHER_DDL: {
                this.processOtherDdl(call);
                break;
            }
            default: {
                throw this.unsupported((SqlNode)call, kind);
            }
        }
    }

    private void processSelect(SqlSelect select) {
        if (select.hasOrderBy()) {
            throw this.unsupported((SqlNode)select.getOrderList(), SqlKind.ORDER_BY);
        }
        if (select.getFetch() != null) {
            throw this.unsupported(select.getFetch(), "LIMIT");
        }
        if (select.getOffset() != null) {
            throw this.unsupported(select.getOffset(), "OFFSET");
        }
    }

    private void processJoin(SqlJoin join) {
        JoinType joinType = join.getJoinType();
        if (joinType != JoinType.INNER && joinType != JoinType.COMMA && joinType != JoinType.CROSS && joinType != JoinType.LEFT) {
            throw this.unsupported((SqlNode)join, joinType.name() + " join");
        }
    }

    private void processOther(SqlCall call) {
        SqlOperator operator = call.getOperator();
        if (SUPPORTED_OPERATORS.contains(operator)) {
            return;
        }
        throw this.unsupported((SqlNode)call, operator.getName());
    }

    private void processOtherDdl(SqlCall call) {
        if (!(call instanceof SqlCreateJob || call instanceof SqlDropJob || call instanceof SqlAlterJob || call instanceof SqlCreateSnapshot || call instanceof SqlDropSnapshot)) {
            throw this.unsupported((SqlNode)call, "OTHER DDL class (" + call.getClass().getSimpleName() + ")");
        }
    }

    private CalciteContextException unsupported(SqlNode node, SqlKind kind) {
        return this.unsupported(node, kind.sql.replace('_', ' '));
    }

    private CalciteContextException unsupported(SqlNode node, String name) {
        return this.error(node, ValidatorResource.RESOURCE.notSupported(name));
    }

    private CalciteContextException error(SqlNode node, Resources.ExInst<SqlValidatorException> error) {
        return SqlUtil.newContextException((SqlParserPos)node.getParserPosition(), error);
    }

    static {
        SUPPORTED_KINDS.add(SqlKind.AND);
        SUPPORTED_KINDS.add(SqlKind.OR);
        SUPPORTED_KINDS.add(SqlKind.NOT);
        SUPPORTED_KINDS.add(SqlKind.PLUS);
        SUPPORTED_KINDS.add(SqlKind.MINUS);
        SUPPORTED_KINDS.add(SqlKind.TIMES);
        SUPPORTED_KINDS.add(SqlKind.DIVIDE);
        SUPPORTED_KINDS.add(SqlKind.MINUS_PREFIX);
        SUPPORTED_KINDS.add(SqlKind.PLUS_PREFIX);
        SUPPORTED_KINDS.add(SqlKind.IS_TRUE);
        SUPPORTED_KINDS.add(SqlKind.IS_NOT_TRUE);
        SUPPORTED_KINDS.add(SqlKind.IS_FALSE);
        SUPPORTED_KINDS.add(SqlKind.IS_NOT_FALSE);
        SUPPORTED_KINDS.add(SqlKind.IS_NULL);
        SUPPORTED_KINDS.add(SqlKind.IS_NOT_NULL);
        SUPPORTED_KINDS.add(SqlKind.EQUALS);
        SUPPORTED_KINDS.add(SqlKind.NOT_EQUALS);
        SUPPORTED_KINDS.add(SqlKind.LESS_THAN);
        SUPPORTED_KINDS.add(SqlKind.GREATER_THAN);
        SUPPORTED_KINDS.add(SqlKind.GREATER_THAN_OR_EQUAL);
        SUPPORTED_KINDS.add(SqlKind.LESS_THAN_OR_EQUAL);
        SUPPORTED_KINDS.add(SqlKind.AS);
        SUPPORTED_KINDS.add(SqlKind.CAST);
        SUPPORTED_KINDS.add(SqlKind.CEIL);
        SUPPORTED_KINDS.add(SqlKind.FLOOR);
        SUPPORTED_KINDS.add(SqlKind.LIKE);
        SUPPORTED_KINDS.add(SqlKind.TRIM);
        SUPPORTED_KINDS.add(SqlKind.COUNT);
        SUPPORTED_KINDS.add(SqlKind.MIN);
        SUPPORTED_KINDS.add(SqlKind.MAX);
        SUPPORTED_KINDS.add(SqlKind.SUM);
        SUPPORTED_KINDS.add(SqlKind.AVG);
        SUPPORTED_KINDS.add(SqlKind.CREATE_TABLE);
        SUPPORTED_KINDS.add(SqlKind.DROP_TABLE);
        SUPPORTED_KINDS.add(SqlKind.COLUMN_DECL);
        SUPPORTED_KINDS.add(SqlKind.ROW);
        SUPPORTED_KINDS.add(SqlKind.VALUES);
        SUPPORTED_KINDS.add(SqlKind.INSERT);
        SUPPORTED_KINDS.add(SqlKind.COLLECTION_TABLE);
        SUPPORTED_OPERATORS = new HashSet<SqlOperator>();
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.COS);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.SIN);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.TAN);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.COT);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.ACOS);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.ASIN);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.ATAN);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.EXP);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.LN);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.LOG10);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.RAND);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.ABS);
        SUPPORTED_OPERATORS.add((SqlOperator)SqlStdOperatorTable.PI);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.SIGN);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.DEGREES);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.RADIANS);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.ROUND);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.TRUNCATE);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.ASCII);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.INITCAP);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.CHAR_LENGTH);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.CHARACTER_LENGTH);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.LENGTH);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.LOWER);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.UPPER);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.CONCAT);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.SUBSTRING);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.LTRIM);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.RTRIM);
        SUPPORTED_OPERATORS.add((SqlOperator)HazelcastSqlOperatorTable.BTRIM);
        SUPPORTED_OPERATORS.add(SqlOption.OPERATOR);
        SUPPORTED_OPERATORS.add((SqlOperator)SqlShowStatement.SHOW_MAPPINGS);
        SUPPORTED_OPERATORS.add((SqlOperator)SqlShowStatement.SHOW_JOBS);
        SUPPORTED_FUNCTIONS = new HashSet<SqlOperator>();
        SUPPORTED_FUNCTIONS.add((SqlOperator)JetSqlOperatorTable.CSV_FILE);
        SUPPORTED_FUNCTIONS.add((SqlOperator)JetSqlOperatorTable.JSON_FILE);
        SUPPORTED_FUNCTIONS.add((SqlOperator)JetSqlOperatorTable.AVRO_FILE);
        SUPPORTED_FUNCTIONS.add((SqlOperator)JetSqlOperatorTable.PARQUET_FILE);
        SUPPORTED_FUNCTIONS.add((SqlOperator)JetSqlOperatorTable.GENERATE_SERIES);
        SUPPORTED_FUNCTIONS.add((SqlOperator)JetSqlOperatorTable.GENERATE_STREAM);
    }
}

