/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.processors;

import com.hazelcast.cluster.Address;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Outbox;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.sql.impl.JetQueryResultProducer;
import com.hazelcast.jet.sql.impl.JetSqlCoreBackendImpl;
import com.hazelcast.sql.impl.QueryId;
import java.io.Serializable;
import javax.annotation.Nonnull;

public final class RootResultConsumerSink
implements Processor {
    private final String queryId;
    private JetQueryResultProducer rootResultConsumer;

    private RootResultConsumerSink(String queryId) {
        this.queryId = queryId;
    }

    public void init(@Nonnull Outbox outbox, @Nonnull Processor.Context context) {
        HazelcastInstanceImpl hzInst = (HazelcastInstanceImpl)context.jetInstance().getHazelcastInstance();
        JetSqlCoreBackendImpl jetSqlCoreBackend = (JetSqlCoreBackendImpl)hzInst.node.nodeEngine.getService("hz:impl:jetSqlCoreBackend");
        this.rootResultConsumer = jetSqlCoreBackend.getResultConsumerRegistry().remove(this.queryId);
        assert (this.rootResultConsumer != null);
    }

    public boolean tryProcess() {
        this.rootResultConsumer.check();
        return true;
    }

    public void process(int ordinal, @Nonnull Inbox inbox) {
        this.rootResultConsumer.consume(inbox);
    }

    public boolean complete() {
        this.rootResultConsumer.done();
        return true;
    }

    public boolean tryProcessWatermark(@Nonnull Watermark watermark) {
        return true;
    }

    public static ProcessorMetaSupplier rootResultConsumerSink(Address initiatorAddress, QueryId queryId) {
        String queryIdStr = queryId.toString();
        ProcessorSupplier pSupplier = ProcessorSupplier.of((SupplierEx & Serializable)() -> new RootResultConsumerSink(queryIdStr));
        return ProcessorMetaSupplier.forceTotalParallelismOne((ProcessorSupplier)pSupplier, (Address)initiatorAddress);
    }
}

