/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.internal.util.Preconditions;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.calcite.sql.SqlAlter;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.ImmutableNullableList;

public class SqlAlterJob
extends SqlAlter {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("ALTER JOB", SqlKind.OTHER_DDL);
    private final SqlIdentifier name;
    private final AlterJobOperation operation;

    public SqlAlterJob(SqlIdentifier name, AlterJobOperation operation, SqlParserPos pos) {
        super(pos, "JOB");
        this.name = Objects.requireNonNull(name, "Name must not be null");
        this.operation = Objects.requireNonNull(operation, "Operation must not be null");
        Preconditions.checkTrue((name.names.size() == 1 ? 1 : 0) != 0, (String)name.toString());
    }

    public String name() {
        return this.name.toString();
    }

    public AlterJobOperation getOperation() {
        return this.operation;
    }

    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name);
    }

    protected void unparseAlterOperation(SqlWriter writer, int leftPrec, int rightPrec) {
        this.name.unparse(writer, leftPrec, rightPrec);
        writer.keyword(this.operation.name());
    }

    public void validate(SqlValidator validator, SqlValidatorScope scope) {
    }

    public static enum AlterJobOperation {
        SUSPEND,
        RESUME,
        RESTART;

    }
}

