/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.google.common.collect.ImmutableList;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.plan.node.PlanNodeFieldTypeProvider;
import com.hazelcast.sql.impl.plan.node.PlanNodeSchema;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.tools.RelBuilderFactory;

abstract class ValuesReduceRule
extends RelOptRule {
    static final ValuesReduceRule FILTER_INSTANCE = new ValuesReduceRule(ValuesReduceRule.operand(LogicalFilter.class, (RelOptRuleOperand)ValuesReduceRule.operand(LogicalValues.class, (RelOptRuleOperandChildren)ValuesReduceRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, ValuesReduceRule.class.getSimpleName() + "(Filter)"){

        public void onMatch(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            Values values = (Values)call.rel(1);
            this.apply(call, null, filter, values);
        }
    };
    static final ValuesReduceRule PROJECT_INSTANCE = new ValuesReduceRule(ValuesReduceRule.operand(LogicalProject.class, (RelOptRuleOperand)ValuesReduceRule.operand(LogicalValues.class, (RelOptRuleOperandChildren)ValuesReduceRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, ValuesReduceRule.class.getSimpleName() + "(Project)"){

        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            Values values = (Values)call.rel(1);
            this.apply(call, project, null, values);
        }
    };
    static final ValuesReduceRule PROJECT_FILTER_INSTANCE = new ValuesReduceRule(ValuesReduceRule.operand(LogicalProject.class, (RelOptRuleOperand)ValuesReduceRule.operand(LogicalFilter.class, (RelOptRuleOperand)ValuesReduceRule.operand(LogicalValues.class, (RelOptRuleOperandChildren)ValuesReduceRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, ValuesReduceRule.class.getSimpleName() + "(Project-Filter)"){

        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            Filter filter = (Filter)call.rel(1);
            Values values = (Values)call.rel(2);
            this.apply(call, project, filter, values);
        }
    };

    private ValuesReduceRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description) {
        super(operand, relBuilderFactory, description);
    }

    protected void apply(RelOptRuleCall call, Project project, Filter filter, Values values) {
        PlanNodeSchema schema = OptUtils.schema(values.getRowType());
        RexVisitor<Expression<?>> converter = OptUtils.createRexToExpressionVisitor((PlanNodeFieldTypeProvider)schema);
        RelDataType rowType = null;
        Expression predicate = null;
        if (filter != null) {
            rowType = filter.getRowType();
            predicate = (Expression)filter.getCondition().accept(converter);
        }
        List projection = null;
        if (project != null) {
            rowType = project.getRowType();
            projection = Util.toList((Collection)project.getProjects(), node -> (Expression)node.accept(converter));
        }
        assert (rowType != null);
        List<Object[]> rows = ExpressionUtil.evaluate((Expression<Boolean>)predicate, projection, OptUtils.convert(values));
        ImmutableList<ImmutableList<RexLiteral>> tuples = ValuesReduceRule.toTuples(rows, rowType.getFieldList(), values.getCluster());
        LogicalValues rel = LogicalValues.create((RelOptCluster)values.getCluster(), (RelDataType)rowType, tuples);
        call.transformTo((RelNode)rel);
    }

    private static ImmutableList<ImmutableList<RexLiteral>> toTuples(List<Object[]> rows, List<RelDataTypeField> fields, RelOptCluster cluster) {
        RelDataTypeFactory typeFactory = cluster.getTypeFactory();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        ImmutableList.Builder tuplesBuilder = new ImmutableList.Builder();
        for (Object[] row : rows) {
            ImmutableList.Builder tupleBuilder = new ImmutableList.Builder();
            for (int i = 0; i < row.length; ++i) {
                assert (row.length == fields.size());
                RelDataType relDataType = typeFactory.createTypeWithNullability(fields.get(i).getType(), false);
                RexLiteral literal = (RexLiteral)rexBuilder.makeLiteral(row[i], relDataType, false);
                tupleBuilder.add((Object)literal);
            }
            ImmutableList tuple = tupleBuilder.build();
            tuplesBuilder.add((Object)tuple);
        }
        return tuplesBuilder.build();
    }
}

