/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.schema.JetTableFunction;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.validate.SqlUserDefinedTableFunction;

final class FullFunctionScanLogicalRule
extends ConverterRule {
    static final RelOptRule INSTANCE = new FullFunctionScanLogicalRule();

    private FullFunctionScanLogicalRule() {
        super(LogicalTableFunctionScan.class, scan -> FullFunctionScanLogicalRule.extractFunction(scan) != null, (RelTrait)Convention.NONE, (RelTrait)Convention.NONE, FullFunctionScanLogicalRule.class.getSimpleName());
    }

    public RelNode convert(RelNode rel) {
        LogicalTableFunctionScan scan = (LogicalTableFunctionScan)rel;
        return OptUtils.createLogicalScan(scan.getCluster(), FullFunctionScanLogicalRule.extractTable(scan));
    }

    private static HazelcastTable extractTable(LogicalTableFunctionScan scan) {
        JetTableFunction function = FullFunctionScanLogicalRule.extractFunction(scan);
        return function.toTable(scan.getRowType());
    }

    private static JetTableFunction extractFunction(LogicalTableFunctionScan scan) {
        if (scan == null || !(scan.getCall() instanceof RexCall)) {
            return null;
        }
        RexCall call = (RexCall)scan.getCall();
        if (!(call.getOperator() instanceof SqlUserDefinedTableFunction)) {
            return null;
        }
        SqlUserDefinedTableFunction operator = (SqlUserDefinedTableFunction)call.getOperator();
        if (!(operator.getFunction() instanceof JetTableFunction)) {
            return null;
        }
        return (JetTableFunction)operator.getFunction();
    }
}

