/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.core.processor.SinkProcessors;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataJavaResolver;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolvers;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvProcessors;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvRowProjector;
import com.hazelcast.jet.sql.impl.connector.map.IMapJoiner;
import com.hazelcast.jet.sql.impl.connector.map.MetadataJsonResolver;
import com.hazelcast.jet.sql.impl.connector.map.MetadataPortableResolver;
import com.hazelcast.jet.sql.impl.inject.UpsertTargetDescriptor;
import com.hazelcast.jet.sql.impl.schema.MappingField;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableStatistics;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.schema.map.MapTableUtils;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IMapSqlConnector
implements SqlConnector {
    public static final String TYPE_NAME = "IMap";
    private final KvMetadataResolvers metadataResolvers = new KvMetadataResolvers(KvMetadataJavaResolver.INSTANCE, MetadataPortableResolver.INSTANCE, MetadataJsonResolver.INSTANCE);

    @Override
    public String typeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isStream() {
        return false;
    }

    @Override
    @Nonnull
    public List<MappingField> resolveAndValidateFields(@Nonnull NodeEngine nodeEngine, @Nonnull Map<String, String> options, @Nonnull List<MappingField> userFields) {
        return this.metadataResolvers.resolveAndValidateFields(userFields, options, nodeEngine);
    }

    @Override
    @Nonnull
    public final Table createTable(@Nonnull NodeEngine nodeEngine, @Nonnull String schemaName, @Nonnull String mappingName, @Nonnull String externalName, @Nonnull Map<String, String> options, @Nonnull List<MappingField> resolvedFields) {
        InternalSerializationService ss = (InternalSerializationService)nodeEngine.getSerializationService();
        KvMetadata keyMetadata = this.metadataResolvers.resolveMetadata(true, resolvedFields, options, ss);
        KvMetadata valueMetadata = this.metadataResolvers.resolveMetadata(false, resolvedFields, options, ss);
        List fields = Stream.concat(keyMetadata.getFields().stream(), valueMetadata.getFields().stream()).collect(Collectors.toList());
        MapService service = (MapService)nodeEngine.getService("hz:impl:mapService");
        MapServiceContext context = service.getMapServiceContext();
        MapContainer container = context.getMapContainer(externalName);
        long estimatedRowCount = MapTableUtils.estimatePartitionedMapRowCount((NodeEngine)nodeEngine, (MapServiceContext)context, (String)externalName);
        boolean hd = container != null && container.getMapConfig().getInMemoryFormat() == InMemoryFormat.NATIVE;
        return new PartitionedMapTable(schemaName, mappingName, externalName, fields, (TableStatistics)new ConstantTableStatistics(estimatedRowCount), keyMetadata.getQueryTargetDescriptor(), valueMetadata.getQueryTargetDescriptor(), (Object)keyMetadata.getUpsertTargetDescriptor(), (Object)valueMetadata.getUpsertTargetDescriptor(), Collections.emptyList(), hd);
    }

    @Override
    public boolean supportsNestedLoopReader() {
        return true;
    }

    @Override
    @Nonnull
    public SqlConnector.VertexWithInputConfig nestedLoopReader(@Nonnull DAG dag, @Nonnull Table table0, @Nullable Expression<Boolean> predicate, @Nonnull List<Expression<?>> projections, @Nonnull JetJoinInfo joinInfo) {
        PartitionedMapTable table = (PartitionedMapTable)table0;
        String name = table.getMapName();
        List fields = table.getFields();
        QueryPath[] paths = (QueryPath[])fields.stream().map(field -> ((MapTableField)field).getPath()).toArray(QueryPath[]::new);
        QueryDataType[] types = (QueryDataType[])fields.stream().map(TableField::getType).toArray(QueryDataType[]::new);
        QueryTargetDescriptor keyDescriptor = table.getKeyDescriptor();
        QueryTargetDescriptor valueDescriptor = table.getValueDescriptor();
        KvRowProjector.Supplier rightRowProjectorSupplier = KvRowProjector.supplier(paths, types, keyDescriptor, valueDescriptor, predicate, projections);
        return IMapJoiner.join(dag, name, IMapSqlConnector.toString(table), joinInfo, rightRowProjectorSupplier);
    }

    @Override
    public boolean supportsSink() {
        return true;
    }

    @Override
    public boolean supportsInsert() {
        return false;
    }

    @Override
    @Nonnull
    public Vertex sink(@Nonnull DAG dag, @Nonnull Table table0) {
        PartitionedMapTable table = (PartitionedMapTable)table0;
        List fields = table.getFields();
        QueryPath[] paths = (QueryPath[])fields.stream().map(field -> ((MapTableField)field).getPath()).toArray(QueryPath[]::new);
        QueryDataType[] types = (QueryDataType[])fields.stream().map(TableField::getType).toArray(QueryDataType[]::new);
        Vertex vStart = dag.newUniqueVertex("Project(" + IMapSqlConnector.toString(table) + ")", KvProcessors.entryProjector(paths, types, (UpsertTargetDescriptor)table.getKeyJetMetadata(), (UpsertTargetDescriptor)table.getValueJetMetadata()));
        Vertex vEnd = dag.newUniqueVertex(IMapSqlConnector.toString(table), SinkProcessors.writeMapP((String)table.getMapName()));
        dag.edge(Edge.between((Vertex)vStart, (Vertex)vEnd));
        return vStart;
    }

    private static String toString(PartitionedMapTable table) {
        return "IMap[" + table.getSchemaName() + "." + table.getSqlName() + "]";
    }
}

