/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.generator;

import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.pipeline.SourceBuilder;
import com.hazelcast.jet.pipeline.StreamSource;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.schema.JetTable;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableStatistics;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;

class StreamTable
extends JetTable {
    private final int rate;

    StreamTable(SqlConnector sqlConnector, List<TableField> fields, String schemaName, String name, int rate) {
        super(sqlConnector, fields, schemaName, name, (TableStatistics)new ConstantTableStatistics(Integer.MAX_VALUE));
        if (rate < 0) {
            throw QueryException.error((String)"rate cannot be less than zero");
        }
        this.rate = rate;
    }

    StreamSource<Object[]> items(Expression<Boolean> predicate, List<Expression<?>> projections) {
        int rate = this.rate;
        return SourceBuilder.stream((String)"stream", (FunctionEx & Serializable)ctx -> new StreamGenerator(rate, predicate, projections)).fillBufferFn((BiConsumerEx & Serializable)(rec$, x$0) -> ((StreamGenerator)rec$).fillBuffer((SourceBuilder.SourceBuffer<Object[]>)x$0)).build();
    }

    private static final class StreamGenerator {
        private static final int MAX_BATCH_SIZE = 1024;
        private static final long NANOS_PER_MICRO = TimeUnit.MICROSECONDS.toNanos(1L);
        private static final long MICROS_PER_SECOND = TimeUnit.SECONDS.toMicros(1L);
        private final long startTime = System.nanoTime();
        private final int rate;
        private final Expression<Boolean> predicate;
        private final List<Expression<?>> projections;
        private long sequence;

        private StreamGenerator(int rate, Expression<Boolean> predicate, List<Expression<?>> projections) {
            this.rate = rate;
            this.predicate = predicate;
            this.projections = projections;
        }

        private void fillBuffer(SourceBuilder.SourceBuffer<Object[]> buffer) {
            long now = System.nanoTime();
            long emitValuesUpTo = (now - this.startTime) / NANOS_PER_MICRO * (long)this.rate / MICROS_PER_SECOND;
            for (int i = 0; i < 1024 && this.sequence < emitValuesUpTo; ++i) {
                Object[] row = ExpressionUtil.evaluate(this.predicate, this.projections, new Object[]{this.sequence});
                if (row != null) {
                    buffer.add((Object)row);
                }
                ++this.sequence;
            }
        }
    }
}

