/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.generator;

import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.test.TestSources;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.schema.JetTable;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableStatistics;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

class SeriesTable
extends JetTable {
    private final int start;
    private final int stop;
    private final int step;

    SeriesTable(SqlConnector sqlConnector, List<TableField> fields, String schemaName, String name, int start, int stop, int step) {
        super(sqlConnector, fields, schemaName, name, (TableStatistics)new ConstantTableStatistics(SeriesTable.numberOfItems(start, stop, step)));
        this.start = start;
        this.stop = stop;
        this.step = step;
    }

    BatchSource<Object[]> items(Expression<Boolean> predicate, List<Expression<?>> projections) {
        return TestSources.items((Iterable)new SeriesGenerator(this.start, this.stop, this.step, predicate, projections));
    }

    long numberOfItems() {
        return SeriesTable.numberOfItems(this.start, this.stop, this.step);
    }

    private static long numberOfItems(int start, int stop, int step) {
        if (step == 0) {
            throw QueryException.error((String)"step cannot equal zero");
        }
        if (start <= stop) {
            return step < 0 ? 0L : ((long)stop - (long)start) / (long)step + 1L;
        }
        return step > 0 ? 0L : ((long)start - (long)stop) / (long)(-step) + 1L;
    }

    private static final class SeriesGenerator
    implements Iterable<Object[]>,
    Serializable {
        private int start;
        private int stop;
        private int step;
        private Expression<Boolean> predicate;
        private List<Expression<?>> projections;

        private SeriesGenerator() {
        }

        private SeriesGenerator(int start, int stop, int step, Expression<Boolean> predicate, List<Expression<?>> projections) {
            this.start = start;
            this.stop = stop;
            this.step = step;
            this.predicate = predicate;
            this.projections = projections;
        }

        @Override
        @Nonnull
        public Iterator<Object[]> iterator() {
            return IntStream.iterate(this.start, i -> i + this.step).limit(SeriesTable.numberOfItems(this.start, this.stop, this.step)).mapToObj(i -> ExpressionUtil.evaluate(this.predicate, this.projections, new Object[]{i})).filter(Objects::nonNull).iterator();
        }
    }
}

