/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.generator;

import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.jet.sql.impl.connector.generator.SeriesSqlConnector;
import com.hazelcast.jet.sql.impl.connector.generator.SeriesTable;
import com.hazelcast.jet.sql.impl.schema.JetTableFunction;
import com.hazelcast.jet.sql.impl.schema.JetTableFunctionParameter;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTableStatistic;
import com.hazelcast.sql.impl.schema.Table;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.sql.type.SqlTypeName;

public final class SeriesGeneratorTableFunction
extends JetTableFunction {
    public static final SeriesGeneratorTableFunction GENERATE_SERIES = new SeriesGeneratorTableFunction();
    private static final String SCHEMA_NAME_SERIES = "series";
    private static final List<FunctionParameter> PARAMETERS = Arrays.asList(new JetTableFunctionParameter(0, "start", SqlTypeName.INTEGER, true), new JetTableFunctionParameter(1, "stop", SqlTypeName.INTEGER, true), new JetTableFunctionParameter(2, "step", SqlTypeName.INTEGER, false));

    private SeriesGeneratorTableFunction() {
        super(SeriesSqlConnector.INSTANCE);
    }

    public List<FunctionParameter> getParameters() {
        return PARAMETERS;
    }

    @Override
    protected HazelcastTable toTable(List<Object> arguments) {
        int start = (Integer)arguments.get(0);
        int stop = (Integer)arguments.get(1);
        int step = arguments.get(2) != null ? (Integer)arguments.get(2) : 1;
        SeriesTable table = SeriesSqlConnector.createTable(SCHEMA_NAME_SERIES, SeriesGeneratorTableFunction.randomName(), start, stop, step);
        return new HazelcastTable((Table)table, (Statistic)new HazelcastTableStatistic(table.numberOfItems()));
    }

    private static String randomName() {
        return "series_" + UuidUtil.newUnsecureUuidString().replace('-', '_');
    }
}

