/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector;

import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.extract.QueryExtractor;
import com.hazelcast.sql.impl.extract.QueryTarget;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.List;

public class RowProjector
implements Row {
    private final QueryTarget target;
    private final QueryExtractor[] extractors;
    private final Expression<Boolean> predicate;
    private final List<Expression<?>> projection;

    RowProjector(String[] paths, QueryDataType[] types, QueryTarget target, Expression<Boolean> predicate, List<Expression<?>> projection) {
        this.target = target;
        this.extractors = RowProjector.createExtractors(target, paths, types);
        this.predicate = predicate != null ? predicate : ConstantExpression.create((Object)true, (QueryDataType)QueryDataType.BOOLEAN);
        this.projection = projection;
    }

    private static QueryExtractor[] createExtractors(QueryTarget target, String[] paths, QueryDataType[] types) {
        QueryExtractor[] extractors = new QueryExtractor[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            QueryDataType type = types[i];
            extractors[i] = target.createExtractor(path, type);
        }
        return extractors;
    }

    public Object[] project(Object object) {
        this.target.setTarget(object);
        if (!Boolean.TRUE.equals(ExpressionUtil.evaluate(this.predicate, this))) {
            return null;
        }
        Object[] row = new Object[this.projection.size()];
        for (int i = 0; i < this.projection.size(); ++i) {
            row[i] = ExpressionUtil.evaluate(this.projection.get(i), this);
        }
        return row;
    }

    public <T> T get(int index) {
        return (T)this.extractors[index].get();
    }

    public int getColumnCount() {
        return this.extractors.length;
    }
}

