/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.jet.sql.impl.aggregate.SqlAggregation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.math.ExpressionMath;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.converter.Converter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SumSqlAggregation
extends SqlAggregation {
    private QueryDataType operandType;
    private QueryDataType resultType;
    private Object value;

    private SumSqlAggregation() {
    }

    public SumSqlAggregation(int index, QueryDataType operandType) {
        this(index, operandType, false);
    }

    public SumSqlAggregation(int index, QueryDataType operandType, boolean distinct) {
        super(index, true, distinct);
        this.operandType = operandType;
        this.resultType = SumSqlAggregation.inferResultType(operandType);
    }

    private static QueryDataType inferResultType(QueryDataType operandType) {
        switch (operandType.getTypeFamily()) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return QueryDataType.BIGINT;
            }
            case DECIMAL: {
                return QueryDataType.DECIMAL;
            }
            case REAL: 
            case DOUBLE: {
                return QueryDataType.DOUBLE;
            }
        }
        throw QueryException.error((String)("Unsupported operand type: " + operandType));
    }

    @Override
    public QueryDataType resultType() {
        return this.resultType;
    }

    @Override
    protected void accumulate(Object value) {
        this.add(value, this.operandType.getConverter());
    }

    @Override
    public void combine(SqlAggregation other0) {
        SumSqlAggregation other = (SumSqlAggregation)other0;
        Object value = other.value;
        if (value != null) {
            this.add(value, this.resultType.getConverter());
        }
    }

    private void add(Object value, Converter converter) {
        if (this.value == null) {
            this.value = this.identity();
        }
        switch (this.resultType.getTypeFamily()) {
            case BIGINT: {
                try {
                    this.value = Math.addExact((Long)this.value, converter.asBigint(value));
                    break;
                }
                catch (ArithmeticException e) {
                    throw QueryException.dataException((String)(QueryDataTypeFamily.BIGINT + " overflow in 'SUM' function (consider adding explicit CAST to DECIMAL)"));
                }
            }
            case DECIMAL: {
                this.value = ((BigDecimal)this.value).add(converter.asDecimal(value), ExpressionMath.DECIMAL_MATH_CONTEXT);
                break;
            }
            default: {
                assert (this.resultType.getTypeFamily() == QueryDataTypeFamily.DOUBLE);
                this.value = (Double)this.value + converter.asDouble(value);
            }
        }
    }

    private Object identity() {
        switch (this.resultType.getTypeFamily()) {
            case BIGINT: {
                return 0L;
            }
            case DECIMAL: {
                return BigDecimal.ZERO;
            }
        }
        assert (this.resultType.getTypeFamily() == QueryDataTypeFamily.DOUBLE);
        return 0.0;
    }

    @Override
    public Object collect() {
        return this.value;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject((Object)this.operandType);
        out.writeObject((Object)this.resultType);
        out.writeObject(this.value);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.operandType = (QueryDataType)in.readObject();
        this.resultType = (QueryDataType)in.readObject();
        this.value = in.readObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SumSqlAggregation that = (SumSqlAggregation)o;
        return Objects.equals(this.operandType, that.operandType) && Objects.equals(this.resultType, that.resultType) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.operandType, this.resultType, this.value);
    }
}

