/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.jet.sql.impl.aggregate.SqlAggregation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SqlAggregations
implements DataSerializable {
    private SqlAggregation[] aggregations;

    private SqlAggregations() {
    }

    public SqlAggregations(SqlAggregation[] aggregations) {
        this.aggregations = aggregations;
    }

    public void accumulate(Object[] row) {
        for (SqlAggregation aggregation : this.aggregations) {
            aggregation.accumulate(row);
        }
    }

    public void combine(SqlAggregations other) {
        assert (this.aggregations.length == other.aggregations.length);
        for (int i = 0; i < this.aggregations.length; ++i) {
            this.aggregations[i].combine(other.aggregations[i]);
        }
    }

    public Object[] collect() {
        Object[] values = new Object[this.aggregations.length];
        for (int i = 0; i < this.aggregations.length; ++i) {
            values[i] = this.aggregations[i].collect();
        }
        return values;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.aggregations.length);
        for (SqlAggregation aggregation : this.aggregations) {
            out.writeObject((Object)aggregation);
        }
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.aggregations = new SqlAggregation[in.readInt()];
        for (int i = 0; i < this.aggregations.length; ++i) {
            this.aggregations[i] = (SqlAggregation)in.readObject();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlAggregations that = (SqlAggregations)o;
        return Arrays.equals(this.aggregations, that.aggregations);
    }

    public int hashCode() {
        return Arrays.hashCode(this.aggregations);
    }
}

