/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.HashSet;
import java.util.Set;

public abstract class SqlAggregation
implements DataSerializable {
    private int index;
    private boolean ignoreNulls;
    private Set<Object> values;

    protected SqlAggregation() {
    }

    protected SqlAggregation(int index, boolean ignoreNulls, boolean distinct) {
        this.index = index;
        this.ignoreNulls = ignoreNulls;
        this.values = distinct ? new HashSet() : null;
    }

    public abstract QueryDataType resultType();

    public final void accumulate(Object[] row) {
        Object value;
        Object object = value = this.index > -1 ? row[this.index] : null;
        if (value == null && this.ignoreNulls) {
            return;
        }
        if (value != null && this.values != null && !this.values.add(value)) {
            return;
        }
        this.accumulate(value);
    }

    protected abstract void accumulate(Object var1);

    public abstract void combine(SqlAggregation var1);

    public abstract Object collect();
}

