/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.jet.sql.impl.aggregate.SqlAggregation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MinSqlAggregation
extends SqlAggregation {
    private QueryDataType operandType;
    private Object value;

    private MinSqlAggregation() {
    }

    public MinSqlAggregation(int index, QueryDataType operandType) {
        super(index, true, false);
        this.operandType = operandType;
    }

    @Override
    public QueryDataType resultType() {
        return this.operandType;
    }

    @Override
    protected void accumulate(Object value) {
        if (this.value == null || this.compare(this.value, value) > 0) {
            this.value = value;
        }
    }

    @Override
    public void combine(SqlAggregation other0) {
        MinSqlAggregation other = (MinSqlAggregation)other0;
        Object value = other.value;
        if (this.value == null || value != null && this.compare(this.value, value) > 0) {
            this.value = value;
        }
    }

    private int compare(Object left, Object right) {
        assert (left != null);
        assert (right != null);
        Comparable<?> leftComparable = MinSqlAggregation.asComparable(left);
        Comparable<?> rightComparable = MinSqlAggregation.asComparable(right);
        return leftComparable.compareTo(rightComparable);
    }

    private static Comparable<?> asComparable(Object value) {
        if (value instanceof Comparable) {
            return (Comparable)value;
        }
        throw QueryException.error((String)("MIN not supported for " + value.getClass() + ": not comparable"));
    }

    @Override
    public Object collect() {
        return this.value;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject((Object)this.operandType);
        out.writeObject(this.value);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.operandType = (QueryDataType)in.readObject();
        this.value = in.readObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MinSqlAggregation that = (MinSqlAggregation)o;
        return Objects.equals(this.operandType, that.operandType) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.operandType, this.value);
    }
}

