/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.JobStateSnapshot;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.sql.impl.JetPlan;
import com.hazelcast.jet.sql.impl.JetQueryResultProducer;
import com.hazelcast.jet.sql.impl.JetSqlResultImpl;
import com.hazelcast.jet.sql.impl.JetStaticQueryResultProducer;
import com.hazelcast.jet.sql.impl.parse.SqlShowStatement;
import com.hazelcast.jet.sql.impl.schema.MappingCatalog;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.SqlResultImpl;
import com.hazelcast.sql.impl.row.HeapRow;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.stream.Stream;

class JetPlanExecutor {
    private final MappingCatalog catalog;
    private final JetInstance jetInstance;
    private final Map<String, JetQueryResultProducer> resultConsumerRegistry;

    JetPlanExecutor(MappingCatalog catalog, JetInstance jetInstance, Map<String, JetQueryResultProducer> resultConsumerRegistry) {
        this.catalog = catalog;
        this.jetInstance = jetInstance;
        this.resultConsumerRegistry = resultConsumerRegistry;
    }

    SqlResult execute(JetPlan.CreateMappingPlan plan) {
        this.catalog.createMapping(plan.mapping(), plan.replace(), plan.ifNotExists());
        return SqlResultImpl.createUpdateCountResult((long)0L);
    }

    SqlResult execute(JetPlan.DropMappingPlan plan) {
        this.catalog.removeMapping(plan.name(), plan.ifExists());
        return SqlResultImpl.createUpdateCountResult((long)0L);
    }

    SqlResult execute(JetPlan.CreateJobPlan plan) {
        if (plan.isIfNotExists()) {
            this.jetInstance.newJobIfAbsent(plan.getExecutionPlan().getDag(), plan.getJobConfig());
        } else {
            this.jetInstance.newJob(plan.getExecutionPlan().getDag(), plan.getJobConfig());
        }
        return SqlResultImpl.createUpdateCountResult((long)0L);
    }

    SqlResult execute(JetPlan.AlterJobPlan plan) {
        Job job = this.jetInstance.getJob(plan.getJobName());
        if (job == null) {
            throw QueryException.error((String)("The job '" + plan.getJobName() + "' doesn't exist"));
        }
        switch (plan.getOperation()) {
            case SUSPEND: {
                job.suspend();
                break;
            }
            case RESUME: {
                job.resume();
                break;
            }
            case RESTART: {
                job.restart();
                break;
            }
        }
        return SqlResultImpl.createUpdateCountResult((long)0L);
    }

    SqlResult execute(JetPlan.DropJobPlan plan) {
        boolean jobTerminated;
        Job job = this.jetInstance.getJob(plan.getJobName());
        boolean bl = jobTerminated = job != null && job.getStatus().isTerminal();
        if (job == null || jobTerminated) {
            if (plan.isIfExists()) {
                return SqlResultImpl.createUpdateCountResult((long)0L);
            }
            if (jobTerminated) {
                throw QueryException.error((String)("Job already terminated: " + plan.getJobName()));
            }
            throw QueryException.error((String)("Job doesn't exist: " + plan.getJobName()));
        }
        if (plan.getWithSnapshotName() != null) {
            job.cancelAndExportSnapshot(plan.getWithSnapshotName());
        } else {
            job.cancel();
        }
        try {
            job.join();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        return SqlResultImpl.createUpdateCountResult((long)0L);
    }

    SqlResult execute(JetPlan.CreateSnapshotPlan plan) {
        Job job = this.jetInstance.getJob(plan.getJobName());
        if (job == null) {
            throw QueryException.error((String)("The job '" + plan.getJobName() + "' doesn't exist"));
        }
        job.exportSnapshot(plan.getSnapshotName());
        return SqlResultImpl.createUpdateCountResult((long)0L);
    }

    SqlResult execute(JetPlan.DropSnapshotPlan plan) {
        JobStateSnapshot snapshot = this.jetInstance.getJobStateSnapshot(plan.getSnapshotName());
        if (snapshot == null) {
            if (plan.isIfExists()) {
                return SqlResultImpl.createUpdateCountResult((long)0L);
            }
            throw QueryException.error((String)("The snapshot doesnt exist: " + plan.getSnapshotName()));
        }
        snapshot.destroy();
        return SqlResultImpl.createUpdateCountResult((long)0L);
    }

    SqlResult execute(JetPlan.SelectOrSinkPlan plan) {
        if (plan.isInsert()) {
            if (plan.isStreaming()) {
                throw QueryException.error((String)"Cannot execute a streaming DML statement without a CREATE JOB command");
            }
            Job job = this.jetInstance.newJob(plan.getDag());
            job.join();
            return SqlResultImpl.createUpdateCountResult((long)0L);
        }
        JetQueryResultProducer queryResultProducer = new JetQueryResultProducer();
        String queryIdStr = plan.getQueryId().toString();
        JetQueryResultProducer oldValue = this.resultConsumerRegistry.put(queryIdStr, queryResultProducer);
        assert (oldValue == null) : oldValue;
        try {
            Job job = this.jetInstance.newJob(plan.getDag());
            job.getFuture().whenComplete((r, t) -> {
                if (t != null) {
                    queryResultProducer.onError(QueryException.error((String)t.toString()));
                }
            });
        }
        catch (Throwable e) {
            this.resultConsumerRegistry.remove(queryIdStr);
            throw e;
        }
        return new JetSqlResultImpl(plan.getQueryId(), queryResultProducer, plan.getRowMetadata());
    }

    public SqlResult execute(JetPlan.ShowStatementPlan plan) {
        Stream<Object> rows;
        SqlRowMetadata metadata = new SqlRowMetadata(Collections.singletonList(new SqlColumnMetadata("name", SqlColumnType.VARCHAR)));
        if (plan.getShowTarget() == SqlShowStatement.ShowStatementTarget.MAPPINGS) {
            rows = this.catalog.getMappingNames().stream();
        } else {
            assert (plan.getShowTarget() == SqlShowStatement.ShowStatementTarget.JOBS);
            JetService jetService = (JetService)((HazelcastInstanceImpl)this.jetInstance.getHazelcastInstance()).node.nodeEngine.getService("hz:impl:jetService");
            rows = jetService.getJobRepository().getJobRecords().stream().map(record -> record.getConfig().getName()).filter(Objects::nonNull);
        }
        return new JetSqlResultImpl(QueryId.create((UUID)this.jetInstance.getHazelcastInstance().getLocalEndpoint().getUuid()), new JetStaticQueryResultProducer(rows.sorted().map(name -> new HeapRow(new Object[]{name})).iterator()), metadata);
    }
}

