/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.cdc.postgres;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.jet.annotation.EvolvingApi;
import com.hazelcast.jet.cdc.ChangeRecord;
import com.hazelcast.jet.cdc.impl.ChangeRecordCdcSourceP;
import com.hazelcast.jet.cdc.impl.DebeziumConfig;
import com.hazelcast.jet.cdc.impl.PropertyRules;
import com.hazelcast.jet.cdc.postgres.impl.PostgresSequenceExtractor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.pipeline.Sources;
import com.hazelcast.jet.pipeline.StreamSource;
import com.hazelcast.jet.retry.RetryStrategy;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.spi.Snapshotter;
import java.io.Serializable;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;

@EvolvingApi
public final class PostgresCdcSources {
    private PostgresCdcSources() {
    }

    @Nonnull
    public static Builder postgres(@Nonnull String name) {
        return new Builder(name);
    }

    public static final class Builder {
        private static final PropertyRules RULES = new PropertyRules().required("database.hostname").required("database.user").required("database.password").required("database.dbname").inclusive("database.sslkey", "database.sslpassword").exclusive("schema.whitelist", "schema.blacklist").exclusive("table.whitelist", "table.blacklist");
        private final DebeziumConfig config;

        private Builder(@Nonnull String name) {
            Objects.requireNonNull(name, "name");
            this.config = new DebeziumConfig(name, "io.debezium.connector.postgresql.PostgresConnector");
            this.config.setProperty("sequence.extractor.class", PostgresSequenceExtractor.class.getName());
            this.config.setProperty("db.specific.extra.fields", "schema");
            this.config.setProperty("database.server.name", UuidUtil.newUnsecureUuidString());
            this.config.setProperty("snapshot.mode", "initial");
        }

        @Nonnull
        public Builder setSnapshotMode(@Nonnull PostgresSnapshotMode snapshotMode) {
            this.config.setProperty("snapshot.mode", (switch (snapshotMode) {
                case PostgresSnapshotMode.ALWAYS -> PostgresConnectorConfig.SnapshotMode.ALWAYS;
                case PostgresSnapshotMode.INITIAL -> PostgresConnectorConfig.SnapshotMode.INITIAL;
                case PostgresSnapshotMode.INITIAL_ONLY -> PostgresConnectorConfig.SnapshotMode.INITIAL_ONLY;
                case PostgresSnapshotMode.NEVER -> PostgresConnectorConfig.SnapshotMode.NEVER;
                default -> throw new IllegalArgumentException("unsupported snapshot mode " + String.valueOf((Object)snapshotMode));
            }).getValue());
            return this;
        }

        @Nonnull
        public Builder setCustomSnapshotter(@Nonnull Class<?> snapshotterClass) {
            Preconditions.checkState((boolean)Snapshotter.class.isAssignableFrom(snapshotterClass), (String)"snapshotterClass must be a subclass of Snapshotter");
            this.config.setProperty("snapshot.mode", PostgresConnectorConfig.SnapshotMode.CUSTOM.getValue());
            this.config.setProperty("snapshot.custom.class", snapshotterClass.getName());
            return this;
        }

        @Nonnull
        public Builder setDatabaseAddress(@Nonnull String address) {
            this.config.setProperty("database.hostname", address);
            return this;
        }

        @Nonnull
        public Builder setDatabasePort(int port) {
            this.config.setProperty("database.port", Integer.toString(port));
            return this;
        }

        @Nonnull
        public Builder setDatabaseUser(@Nonnull String user) {
            this.config.setProperty("database.user", user);
            return this;
        }

        @Nonnull
        public Builder setDatabasePassword(@Nonnull String password) {
            this.config.setProperty("database.password", password);
            return this;
        }

        @Nonnull
        public Builder setDatabaseName(@Nonnull String dbName) {
            this.config.setProperty("database.dbname", dbName);
            return this;
        }

        @Nonnull
        public Builder setSchemaWhitelist(String ... schemaNameRegExps) {
            this.config.setProperty("schema.whitelist", schemaNameRegExps);
            return this;
        }

        @Nonnull
        public Builder setSchemaBlacklist(String ... schemaNameRegExps) {
            this.config.setProperty("schema.blacklist", schemaNameRegExps);
            return this;
        }

        @Nonnull
        public Builder setTableWhitelist(String ... tableNameRegExps) {
            this.config.setProperty("table.whitelist", tableNameRegExps);
            return this;
        }

        @Nonnull
        public Builder setTableBlacklist(String ... tableNameRegExps) {
            this.config.setProperty("table.blacklist", tableNameRegExps);
            return this;
        }

        @Nonnull
        public Builder setColumnBlacklist(String ... columnNameRegExps) {
            this.config.setProperty("column.blacklist", columnNameRegExps);
            return this;
        }

        @Nonnull
        public Builder setLogicalDecodingPlugIn(@Nonnull String pluginName) {
            this.config.setProperty("plugin.name", pluginName);
            return this;
        }

        @Nonnull
        public Builder setReplicationSlotName(@Nonnull String slotName) {
            this.config.setProperty("slot.name", slotName);
            return this;
        }

        @Nonnull
        public Builder setReplicationSlotDropOnStop(boolean dropOnStop) {
            this.config.setProperty("slot.drop.on.stop", dropOnStop);
            return this;
        }

        @Nonnull
        public Builder setPublicationName(@Nonnull String publicationName) {
            this.config.setProperty("publication.name", publicationName);
            return this;
        }

        @Nonnull
        public Builder setSslMode(@Nonnull String mode) {
            this.config.setProperty("database.sslmode", mode);
            return this;
        }

        @Nonnull
        public Builder setSslCertificateFile(@Nonnull String file) {
            this.config.setProperty("database.sslcert", file);
            return this;
        }

        @Nonnull
        public Builder setSslKeyFile(@Nonnull String file) {
            this.config.setProperty("database.sslkey", file);
            return this;
        }

        @Nonnull
        public Builder setSslKeyFilePassword(@Nonnull String password) {
            this.config.setProperty("database.sslpassword", password);
            return this;
        }

        @Nonnull
        public Builder setSslRootCertificateFile(@Nonnull String file) {
            this.config.setProperty("database.sslrootcert", file);
            return this;
        }

        @Nonnull
        public Builder setReconnectBehavior(@Nonnull RetryStrategy retryStrategy) {
            this.config.setProperty("reconnect.behavior", (Object)retryStrategy);
            return this;
        }

        @Nonnull
        public Builder setShouldStateBeResetOnReconnect(boolean reset) {
            this.config.setProperty("reconnect.reset.state", reset);
            return this;
        }

        @Nonnull
        public Builder setCommitPeriod(long milliseconds) {
            if (milliseconds < 0L) {
                throw new IllegalArgumentException("Negative commit period not allowed");
            }
            this.config.setProperty("commit.period", milliseconds);
            return this;
        }

        @Nonnull
        public Builder setCustomProperty(@Nonnull String key, @Nonnull String value) {
            this.config.setProperty(key, value);
            return this;
        }

        @Nonnull
        public StreamSource<ChangeRecord> build() {
            Properties properties = this.config.toProperties();
            RULES.check(properties);
            return Sources.streamFromProcessorWithWatermarks((String)properties.getProperty("name"), (boolean)true, (FunctionEx & Serializable)eventTimePolicy -> ProcessorMetaSupplier.forceTotalParallelismOne((ProcessorSupplier)ProcessorSupplier.of((SupplierEx & Serializable)() -> new ChangeRecordCdcSourceP(properties, eventTimePolicy))));
        }
    }

    public static enum PostgresSnapshotMode {
        ALWAYS,
        INITIAL,
        NEVER,
        INITIAL_ONLY;

    }
}

