/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.cdc.postgres.impl;

import com.hazelcast.internal.util.HashUtil;
import com.hazelcast.jet.cdc.impl.SequenceExtractor;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;

public class PostgresSequenceExtractor
implements SequenceExtractor {
    private static final String SERVER = "server";
    private static final String LAST_WAL_SEQUENCE_NUMBER = "lsn";
    private String server;
    private long source;

    public long sequence(Map<String, ?> debeziumOffset) {
        return (Long)debeziumOffset.get(LAST_WAL_SEQUENCE_NUMBER);
    }

    public long source(Map<String, ?> debeziumPartition, Map<String, ?> debeziumOffset) {
        String server = (String)debeziumPartition.get(SERVER);
        if (this.isSourceNew(server)) {
            long source = PostgresSequenceExtractor.computeSource(server);
            this.source = this.adjustForCollision(source);
            this.server = server;
        }
        return this.source;
    }

    private boolean isSourceNew(String server) {
        return !Objects.equals(this.server, server);
    }

    private static long computeSource(String server) {
        byte[] bytes = server.getBytes(StandardCharsets.UTF_8);
        return HashUtil.MurmurHash3_x64_64((byte[])bytes, (int)0, (int)bytes.length);
    }

    private long adjustForCollision(long source) {
        if (this.source == source) {
            if (source == Long.MAX_VALUE) {
                return Long.MIN_VALUE;
            }
            return Long.MAX_VALUE;
        }
        return source;
    }
}

