/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.wordcount;

import com.hazelcast.jet.IMapJet;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.aggregate.AggregateOperations;
import com.hazelcast.jet.function.FunctionEx;
import com.hazelcast.jet.function.Functions;
import com.hazelcast.jet.function.PredicateEx;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.Sources;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class WordCount {
    private static final String BOOK_LINES = "bookLines";
    private static final String COUNTS = "counts";
    private JetInstance jet;

    private static Pipeline buildPipeline() {
        Pattern delimiter = Pattern.compile("\\W+");
        Pipeline p = Pipeline.create();
        p.drawFrom(Sources.map((String)BOOK_LINES)).flatMap((FunctionEx & Serializable)e -> Traversers.traverseArray((Object[])delimiter.split(((String)e.getValue()).toLowerCase()))).filter((PredicateEx & Serializable)word -> !word.isEmpty()).groupingKey(Functions.wholeItem()).aggregate(AggregateOperations.counting()).drainTo(Sinks.map((String)COUNTS));
        return p;
    }

    public static void main(String[] args) {
        new WordCount().go();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void go() {
        try {
            this.setup();
            System.out.print("\nCounting words... ");
            long start = System.nanoTime();
            Pipeline p = WordCount.buildPipeline();
            this.jet.newJob(p).join();
            System.out.print("done in " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) + " milliseconds.");
            this.printResults();
            IMapJet counts = this.jet.getMap(COUNTS);
            if ((Long)counts.get((Object)"the") != 27843L) {
                throw new AssertionError((Object)"Wrong count of 'the'");
            }
            System.out.println("Count of 'the' is valid");
        }
        finally {
            Jet.shutdownAll();
        }
    }

    private void setup() {
        System.out.println("Creating Jet instance 1");
        this.jet = Jet.newJetInstance();
        System.out.println("Creating Jet instance 2");
        Jet.newJetInstance();
        System.out.println("Loading The Complete Works of William Shakespeare");
        try {
            long[] lineNum = new long[]{0L};
            HashMap bookLines = new HashMap();
            InputStream stream = this.getClass().getResourceAsStream("/books/shakespeare-complete-works.txt");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                reader.lines().forEach(line -> {
                    lineNum[0] = lineNum[0] + 1L;
                    bookLines.put(lineNum[0], line);
                });
            }
            this.jet.getMap(BOOK_LINES).putAll(bookLines);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void printResults() {
        int limit = 100;
        System.out.format(" Top %d entries are:%n", 100);
        IMapJet counts = this.jet.getMap(COUNTS);
        System.out.println("/-------+---------\\");
        System.out.println("| Count | Word    |");
        System.out.println("|-------+---------|");
        counts.entrySet().stream().sorted(Comparator.comparingLong(Map.Entry::getValue).reversed()).limit(100L).forEach(e -> System.out.format("|%6d | %-8s|%n", e.getValue(), e.getKey()));
        System.out.println("\\-------+---------/");
    }
}

