/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.sockets;

import com.hazelcast.function.ConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.examples.sockets.NettyServer;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.Sources;
import com.hazelcast.map.IMap;
import io.netty.channel.Channel;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.IntStream;

public class WriteTextSocket {
    private static final String HOST = "localhost";
    private static final int PORT = 5252;
    private static final int SOURCE_ITEM_COUNT = 100000;
    private static final String SOURCE_NAME = "map";
    private static final AtomicInteger COUNTER = new AtomicInteger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        NettyServer nettyServer = new NettyServer(5252, (Consumer<Channel>)ConsumerEx.noop(), msg -> COUNTER.incrementAndGet());
        nettyServer.start();
        JetInstance jet = Jet.bootstrappedInstance();
        try {
            System.out.println("Populating map...");
            IMap map = jet.getMap(SOURCE_NAME);
            IntStream.range(0, 100000).parallel().forEach(i -> {
                Integer cfr_ignored_0 = (Integer)map.put((Object)i, (Object)i);
            });
            Pipeline p = Pipeline.create();
            p.readFrom(Sources.map((String)SOURCE_NAME)).writeTo(Sinks.socket((String)HOST, (int)5252, (FunctionEx & Serializable)e -> e.getValue().toString(), (Charset)StandardCharsets.UTF_8));
            System.out.println("Executing job...");
            jet.newJob(p).join();
        }
        finally {
            nettyServer.stop();
            Jet.shutdownAll();
        }
        System.out.println("Server read " + COUNTER.get() + " items from the socket.");
    }
}

