/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.sockets;

import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.examples.sockets.NettyServer;
import com.hazelcast.jet.function.ConsumerEx;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.Sources;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class StreamTextSocket {
    private static final String HOST = "localhost";
    private static final int PORT = 5252;
    private static final String SINK_NAME = "list";
    private static final AtomicInteger COUNTER = new AtomicInteger(100000);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        NettyServer nettyServer = new NettyServer(5252, channel -> {
            int i;
            while ((i = COUNTER.getAndDecrement()) > 0) {
                channel.writeAndFlush((Object)(i + "\n"));
            }
            channel.close();
        }, (Consumer<Object>)ConsumerEx.noop());
        nettyServer.start();
        JetInstance jet = Jet.newJetInstance();
        Jet.newJetInstance();
        try {
            Pipeline p = Pipeline.create();
            p.drawFrom(Sources.socket((String)HOST, (int)5252, (Charset)StandardCharsets.UTF_8)).withoutTimestamps().drainTo(Sinks.list((String)SINK_NAME));
            jet.newJob(p).join();
            System.out.println("Jet received " + jet.getList(SINK_NAME).size() + " items from the socket");
        }
        finally {
            nettyServer.stop();
            Jet.shutdownAll();
        }
    }
}

