/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.protobuf;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.test.TestSources;
import com.hazelcast.jet.protobuf.Messages;
import com.hazelcast.jet.protobuf.ProtobufSerializer;
import java.io.Serializable;

public class ProtobufSerializerAdapter {
    private static final String LIST_NAME = "brokers";
    private JetInstance jet;

    public static void main(String[] args) {
        new ProtobufSerializerAdapter().go();
    }

    private void go() {
        try {
            this.setup();
            JobConfig config = new JobConfig().registerSerializer(Messages.Broker.class, BrokerSerializer.class);
            this.jet.newJob(ProtobufSerializerAdapter.buildPipeline(), config).join();
        }
        finally {
            Jet.shutdownAll();
        }
    }

    private void setup() {
        this.jet = Jet.bootstrappedInstance();
    }

    private static Pipeline buildPipeline() {
        Pipeline p = Pipeline.create();
        p.readFrom(TestSources.items((Object[])new Integer[]{1, 2, 3, 4, 5})).map((FunctionEx & Serializable)id -> Messages.Broker.newBuilder().setId((int)id).build()).writeTo(Sinks.list((String)LIST_NAME));
        return p;
    }

    private static class BrokerSerializer
    extends ProtobufSerializer<Messages.Broker> {
        private static final int TYPED_ID = 13;

        BrokerSerializer() {
            super(Messages.Broker.class, 13);
        }
    }
}

