/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.kafka.avro;

import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.examples.kafka.avro.User;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.kafka.KafkaSources;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryRestApplication;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminUtils;
import kafka.admin.RackAwareMode;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.MockTime;
import kafka.utils.TestUtils;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.utils.Time;
import org.eclipse.jetty.server.Server;

public class KafkaAvroSource {
    private static final String ZK_HOST = "127.0.0.1";
    private static final String BROKER_HOST = "127.0.0.1";
    private static final int SESSION_TIMEOUT = 30000;
    private static final int CONNECTION_TIMEOUT = 30000;
    private static final String AUTO_OFFSET_RESET = "earliest";
    private static final String TOPIC = "topic";
    private EmbeddedZookeeper zkServer;
    private ZkUtils zkUtils;
    private KafkaServer kafkaServer;
    private Server server;
    private int brokerPort;

    private Pipeline buildPipeline() {
        Pipeline p = Pipeline.create();
        p.drawFrom(KafkaSources.kafka((Properties)KafkaAvroSource.props("bootstrap.servers", "127.0.0.1:" + this.brokerPort, "key.deserializer", IntegerDeserializer.class.getName(), "value.deserializer", KafkaAvroDeserializer.class.getName(), "specific.avro.reader", "true", "group.id", UUID.randomUUID().toString(), "schema.registry.url", "http://localhost:8081", "auto.offset.reset", AUTO_OFFSET_RESET), (String[])new String[]{TOPIC})).withoutTimestamps().drainTo(Sinks.logger());
        return p;
    }

    public static void main(String[] args) throws Exception {
        new KafkaAvroSource().go();
    }

    private void go() throws Exception {
        try {
            this.createKafkaCluster();
            this.startSchemaRegistryServer();
            this.createAndFillTopic();
            JetInstance jet = Jet.newJetInstance();
            Job job = jet.newJob(this.buildPipeline());
            TimeUnit.SECONDS.sleep(5L);
            KafkaAvroSource.cancel(job);
        }
        finally {
            this.server.stop();
            Jet.shutdownAll();
            this.shutdownKafkaCluster();
        }
    }

    private void createAndFillTopic() {
        AdminUtils.createTopic((ZkUtils)this.zkUtils, (String)TOPIC, (int)4, (int)1, (Properties)new Properties(), (RackAwareMode)RackAwareMode.Disabled$.MODULE$);
        Properties props = KafkaAvroSource.props("bootstrap.servers", "127.0.0.1:" + this.brokerPort, "key.serializer", IntegerSerializer.class.getName(), "value.serializer", KafkaAvroSerializer.class.getName(), "schema.registry.url", "http://localhost:8081");
        try (KafkaProducer producer = new KafkaProducer(props);){
            for (int i = 0; i < 20; ++i) {
                User user = new User("name" + i, "pass" + i, i, i % 2 == 0);
                producer.send(new ProducerRecord(TOPIC, (Object)i, (Object)user));
            }
        }
    }

    private void createKafkaCluster() throws IOException {
        System.setProperty("zookeeper.preAllocSize", Integer.toString(128));
        this.zkServer = new EmbeddedZookeeper();
        String zkConnect = "127.0.0.1:" + this.zkServer.port();
        ZkClient zkClient = new ZkClient(zkConnect, 30000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
        this.zkUtils = ZkUtils.apply((ZkClient)zkClient, (boolean)false);
        this.brokerPort = KafkaAvroSource.randomPort();
        KafkaConfig config = new KafkaConfig((Map)KafkaAvroSource.props("zookeeper.connect", zkConnect, "broker.id", "0", "log.dirs", Files.createTempDirectory("kafka-", new FileAttribute[0]).toAbsolutePath().toString(), "listeners", "PLAINTEXT://127.0.0.1:" + this.brokerPort, "offsets.topic.replication.factor", "1", "offsets.topic.num.partitions", "1"));
        MockTime mock = new MockTime();
        this.kafkaServer = TestUtils.createServer((KafkaConfig)config, (Time)mock);
    }

    private void startSchemaRegistryServer() throws Exception {
        Properties props = KafkaAvroSource.props("listeners", "http://0.0.0.0:8081", "kafkastore.connection.url", "127.0.0.1:" + this.zkServer.port());
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        SchemaRegistryRestApplication app = new SchemaRegistryRestApplication(config);
        this.server = app.createServer();
        this.server.start();
    }

    private void shutdownKafkaCluster() {
        this.kafkaServer.shutdown();
        this.zkUtils.close();
        this.zkServer.shutdown();
    }

    private static void cancel(Job job) {
        job.cancel();
        while (job.getStatus() != JobStatus.FAILED) {
            Util.uncheckRun(() -> TimeUnit.SECONDS.sleep(1L));
        }
    }

    private static int randomPort() throws IOException {
        try (ServerSocket server = null;){
            server = new ServerSocket(0);
            int n = server.getLocalPort();
            return n;
        }
    }

    private static Properties props(String ... kvs) {
        Properties props = new Properties();
        int i = 0;
        while (i < kvs.length) {
            props.setProperty(kvs[i++], kvs[i++]);
        }
        return props;
    }
}

