/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.jdbc;

import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.examples.jdbc.User;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.Sources;
import com.hazelcast.map.IMap;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.h2.tools.DeleteDbFiles;

public class JdbcSink {
    private static final String MAP_NAME = "userMap";
    private static final String TABLE_NAME = "USER_TABLE";
    private JetInstance jet;
    private String dbDirectory;

    private static Pipeline buildPipeline(String connectionUrl) {
        Pipeline p = Pipeline.create();
        p.readFrom(Sources.map((String)MAP_NAME)).map(Map.Entry::getValue).writeTo(Sinks.jdbc((String)"INSERT INTO USER_TABLE(id, name) VALUES(?, ?)", (String)connectionUrl, (BiConsumerEx & Serializable)(stmt, user) -> {
            stmt.setInt(1, user.getId());
            stmt.setString(2, user.getName());
        }));
        return p;
    }

    public static void main(String[] args) throws Exception {
        new JdbcSink().go();
    }

    private void go() throws Exception {
        try {
            this.setup();
            Pipeline p = JdbcSink.buildPipeline(this.connectionUrl());
            this.jet.newJob(p).join();
            this.printTable();
        }
        finally {
            this.cleanup();
        }
    }

    private void setup() throws Exception {
        this.dbDirectory = Files.createTempDirectory(JdbcSink.class.getName(), new FileAttribute[0]).toString();
        this.createTable();
        this.jet = Jet.bootstrappedInstance();
        IMap map = this.jet.getMap(MAP_NAME);
        for (int i = 0; i < 100; ++i) {
            map.put((Object)i, (Object)new User(i, "name-" + i));
        }
    }

    private void cleanup() {
        Jet.shutdownAll();
        DeleteDbFiles.execute((String)this.dbDirectory, (String)JdbcSink.class.getSimpleName(), (boolean)true);
    }

    private void createTable() throws SQLException {
        try (Connection connection = DriverManager.getConnection(this.connectionUrl());
             Statement statement = connection.createStatement();){
            statement.execute("CREATE TABLE USER_TABLE(id int primary key, name varchar(255))");
        }
    }

    private void printTable() throws SQLException {
        try (Connection connection = DriverManager.getConnection(this.connectionUrl());
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT * FROM USER_TABLE");){
            while (resultSet.next()) {
                System.out.println(new User(resultSet.getInt(1), resultSet.getString(2)));
            }
        }
    }

    private String connectionUrl() {
        return "jdbc:h2:" + this.dbDirectory + "/" + JdbcSink.class.getSimpleName();
    }
}

