/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.imdg;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.collection.IList;
import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.Sources;
import java.util.ArrayList;

public class RemoteListSourceAndSink {
    private static final int ITEM_COUNT = 10;
    private static final String LIST_1 = "list-1";
    private static final String LIST_2 = "list-2";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        JetInstance localJet = Jet.newJetInstance();
        try {
            HazelcastInstance externalHz = RemoteListSourceAndSink.startExternalHazelcast();
            IList sourceList = externalHz.getList(LIST_1);
            for (int i = 0; i < 10; ++i) {
                sourceList.add((Object)i);
            }
            ClientConfig clientConfig = RemoteListSourceAndSink.clientConfigForExternalHazelcast();
            Pipeline p1 = Pipeline.create();
            p1.readFrom(Sources.remoteList((String)LIST_1, (ClientConfig)clientConfig)).writeTo(Sinks.list((String)LIST_1));
            Pipeline p2 = Pipeline.create();
            p2.readFrom(Sources.list((String)LIST_1)).writeTo(Sinks.remoteList((String)LIST_2, (ClientConfig)clientConfig));
            localJet.newJob(p1).join();
            System.out.println("Local list-1 contents: " + new ArrayList(localJet.getList(LIST_1)));
            localJet.newJob(p2).join();
            System.out.println("Remote list-2 contents: " + new ArrayList(externalHz.getList(LIST_2)));
        }
        finally {
            Jet.shutdownAll();
            Hazelcast.shutdownAll();
        }
    }

    private static HazelcastInstance startExternalHazelcast() {
        System.out.println("Creating and populating remote Hazelcast instance...");
        Config config = new Config();
        config.getNetworkConfig().setPort(6701);
        return Hazelcast.newHazelcastInstance((Config)config);
    }

    private static ClientConfig clientConfigForExternalHazelcast() {
        ClientConfig cfg = new ClientConfig();
        cfg.getNetworkConfig().addAddress(new String[]{"localhost:6701"});
        cfg.setClusterName("dev");
        return cfg;
    }
}

