/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.imdg;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.Sources;

public class RemoteMapSourceAndSink {
    private static final String MAP_1 = "map-1";
    private static final String MAP_2 = "map-2";
    private static final int ITEM_COUNT = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        System.setProperty("hazelcast.logging.type", "log4j");
        JetInstance localJet = Jet.newJetInstance();
        try {
            HazelcastInstance externalHz = RemoteMapSourceAndSink.startExternalHazelcast();
            IMap sourceMap = externalHz.getMap(MAP_1);
            for (int i = 0; i < 10; ++i) {
                sourceMap.put((Object)i, (Object)i);
            }
            ClientConfig clientConfig = RemoteMapSourceAndSink.clientConfigForExternalHazelcast();
            Pipeline p1 = Pipeline.create();
            p1.drawFrom(Sources.remoteMap((String)MAP_1, (ClientConfig)clientConfig)).drainTo(Sinks.map((String)MAP_1));
            Pipeline p2 = Pipeline.create();
            p2.drawFrom(Sources.map((String)MAP_1)).drainTo(Sinks.remoteMap((String)MAP_2, (ClientConfig)clientConfig));
            localJet.newJob(p1).join();
            System.out.println("Local map-1 contents: " + localJet.getMap(MAP_1).entrySet());
            localJet.newJob(p2).join();
            System.out.println("Remote map-2 contents: " + externalHz.getMap(MAP_2).entrySet());
        }
        finally {
            Jet.shutdownAll();
            Hazelcast.shutdownAll();
        }
    }

    private static HazelcastInstance startExternalHazelcast() {
        System.out.println("Creating and populating remote Hazelcast instance...");
        Config config = new Config();
        config.getNetworkConfig().setPort(6701);
        return Hazelcast.newHazelcastInstance((Config)config);
    }

    private static ClientConfig clientConfigForExternalHazelcast() {
        ClientConfig cfg = new ClientConfig();
        cfg.getNetworkConfig().addAddress(new String[]{"localhost:6701"});
        cfg.getGroupConfig().setName("dev").setPassword("dev-pass");
        return cfg;
    }
}

